/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.traverser;

import com.baidu.hugegraph.api.graph.GraphAPI;
import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.constant.Direction;
import com.baidu.hugegraph.structure.traverser.Kneighbor;
import com.baidu.hugegraph.structure.traverser.KneighborRequest;
import java.util.LinkedHashMap;
import java.util.List;

public class KneighborAPI
extends TraversersAPI {
    public KneighborAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "kneighbor";
    }

    public List<Object> get(Object sourceId, Direction direction, String label, int depth, long degree, long limit) {
        String source = GraphAPI.formatVertexId(sourceId, false);
        KneighborAPI.checkPositive(depth, "Depth of k-neighbor");
        KneighborAPI.checkDegree(degree);
        KneighborAPI.checkLimit(limit);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_depth", depth);
        params.put("max_degree", degree);
        params.put("limit", limit);
        RestResult result = this.client.get(this.path(), params);
        return result.readList("vertices", Object.class);
    }

    public Kneighbor post(KneighborRequest request) {
        this.client.checkApiVersion("0.58", "customized kneighbor");
        RestResult result = this.client.post(this.path(), request);
        return (Kneighbor)result.readObject(Kneighbor.class);
    }
}

