/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.traverser;

import com.baidu.hugegraph.api.graph.GraphAPI;
import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.constant.Direction;
import java.util.LinkedHashMap;
import java.util.List;

public class SameNeighborsAPI
extends TraversersAPI {
    private static final String SAME_NEIGHBORS = "same_neighbors";

    public SameNeighborsAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "sameneighbors";
    }

    public List<Object> get(Object vertexId, Object otherId, Direction direction, String label, long degree, long limit) {
        this.client.checkApiVersion("0.51", "same neighbors");
        String vertex = GraphAPI.formatVertexId(vertexId, false);
        String other = GraphAPI.formatVertexId(otherId, false);
        SameNeighborsAPI.checkDegree(degree);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("vertex", vertex);
        params.put("other", other);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_degree", degree);
        params.put("limit", limit);
        RestResult result = this.client.get(this.path(), params);
        return result.readList(SAME_NEIGHBORS, Object.class);
    }
}

