/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.traverser;

import com.baidu.hugegraph.api.graph.GraphAPI;
import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.constant.Direction;
import com.baidu.hugegraph.structure.graph.Path;
import java.util.LinkedHashMap;
import java.util.List;

public class ShortestPathAPI
extends TraversersAPI {
    public ShortestPathAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "shortestpath";
    }

    public Path get(Object sourceId, Object targetId, Direction direction, String label, int maxDepth, long degree, long skipDegree, long capacity) {
        String source = GraphAPI.formatVertexId(sourceId, false);
        String target = GraphAPI.formatVertexId(targetId, false);
        ShortestPathAPI.checkPositive(maxDepth, "Max depth of shortest path");
        ShortestPathAPI.checkDegree(degree);
        ShortestPathAPI.checkCapacity(capacity);
        ShortestPathAPI.checkSkipDegree(skipDegree, degree, capacity);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("target", target);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_depth", maxDepth);
        params.put("max_degree", degree);
        params.put("skip_degree", skipDegree);
        params.put("capacity", capacity);
        RestResult result = this.client.get(this.path(), params);
        List vertices = result.readList("path", Object.class);
        return new Path(vertices);
    }
}

