/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.traverser;

import com.baidu.hugegraph.api.graph.GraphAPI;
import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.graph.Shard;
import com.baidu.hugegraph.structure.graph.Vertex;
import com.baidu.hugegraph.structure.graph.Vertices;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VerticesAPI
extends TraversersAPI {
    public VerticesAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "vertices";
    }

    public List<Vertex> list(List<Object> ids) {
        E.checkArgument((ids != null && !ids.isEmpty() ? 1 : 0) != 0, (String)"Ids can't be null or empty", (Object[])new Object[0]);
        ArrayList<String> stringIds = new ArrayList<String>(ids.size());
        for (Object id : ids) {
            stringIds.add(GraphAPI.formatVertexId(id, false));
        }
        LinkedHashMap<String, ArrayList<String>> params = new LinkedHashMap<String, ArrayList<String>>();
        params.put("ids", stringIds);
        RestResult result = this.client.get(this.path(), params);
        return result.readList(this.type(), Vertex.class);
    }

    public List<Shard> shards(long splitSize) {
        String path = String.join((CharSequence)"/", this.path(), "shards");
        ImmutableMap params = ImmutableMap.of((Object)"split_size", (Object)splitSize);
        RestResult result = this.client.get(path, (Map)params);
        return result.readList("shards", Shard.class);
    }

    public Vertices scan(Shard shard, String page, long pageLimit) {
        E.checkArgument((shard != null ? 1 : 0) != 0, (String)"Shard can't be null", (Object[])new Object[0]);
        String path = String.join((CharSequence)"/", this.path(), "scan");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("start", shard.start());
        params.put("end", shard.end());
        params.put("page", page);
        params.put("page_limit", pageLimit);
        RestResult result = this.client.get(path, params);
        return (Vertices)result.readObject(Vertices.class);
    }
}

