/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.driver;

import com.baidu.hugegraph.api.gremlin.GremlinAPI;
import com.baidu.hugegraph.api.gremlin.GremlinRequest;
import com.baidu.hugegraph.api.job.GremlinJobAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.driver.GraphManager;
import com.baidu.hugegraph.structure.gremlin.Response;
import com.baidu.hugegraph.structure.gremlin.ResultSet;

public class GremlinManager {
    private final GraphManager graphManager;
    private GremlinAPI gremlinAPI;
    private GremlinJobAPI gremlinJobAPI;
    private String graph;

    public GremlinManager(RestClient client, String graph, GraphManager graphManager) {
        this.graphManager = graphManager;
        this.gremlinAPI = new GremlinAPI(client);
        this.gremlinJobAPI = new GremlinJobAPI(client, graph);
        this.graph = graph;
    }

    public ResultSet execute(GremlinRequest request) {
        request.aliases.put("graph", this.graph);
        request.aliases.put("g", "__g_" + this.graph);
        Response response = this.gremlinAPI.post(request);
        response.graphManager(this.graphManager);
        return response.result();
    }

    public long executeAsTask(GremlinRequest request) {
        return this.gremlinJobAPI.execute(request);
    }

    public GremlinRequest.Builder gremlin(String gremlin) {
        return new GremlinRequest.Builder(gremlin, this);
    }
}

