/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure.auth;

import com.baidu.hugegraph.structure.auth.AuthElement;
import com.baidu.hugegraph.structure.auth.HugeResource;
import com.baidu.hugegraph.structure.constant.HugeType;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Target
extends AuthElement {
    @JsonProperty(value="target_name")
    private String name;
    @JsonProperty(value="target_graph")
    private String graph;
    @JsonProperty(value="target_url")
    private String url;
    @JsonProperty(value="target_resources")
    private List<HugeResource> resources;
    @JsonProperty(value="target_create")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    protected Date create;
    @JsonProperty(value="target_update")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    protected Date update;
    @JsonProperty(value="target_creator")
    protected String creator;

    @Override
    public String type() {
        return HugeType.TARGET.string();
    }

    @Override
    public Date createTime() {
        return this.create;
    }

    @Override
    public Date updateTime() {
        return this.update;
    }

    @Override
    public String creator() {
        return this.creator;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public String graph() {
        return this.graph;
    }

    public void graph(String graph) {
        this.graph = graph;
    }

    public String url() {
        return this.url;
    }

    public void url(String url) {
        this.url = url;
    }

    public HugeResource resource() {
        if (this.resources == null || this.resources.size() != 1) {
            return null;
        }
        return this.resources.get(0);
    }

    public List<HugeResource> resources() {
        if (this.resources == null) {
            return null;
        }
        return Collections.unmodifiableList(this.resources);
    }

    public void resources(List<HugeResource> resources) {
        this.resources = resources;
    }

    public void resources(HugeResource ... resources) {
        this.resources = Arrays.asList(resources);
    }
}

