/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure.traverser;

import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.structure.constant.Direction;
import com.baidu.hugegraph.structure.traverser.VerticesArgs;
import com.baidu.hugegraph.util.E;
import com.fasterxml.jackson.annotation.JsonProperty;

public class FusiformSimilarityRequest {
    @JsonProperty(value="sources")
    private VerticesArgs sources = null;
    @JsonProperty(value="label")
    public String label = null;
    @JsonProperty(value="direction")
    public String direction = null;
    @JsonProperty(value="min_neighbors")
    public int minNeighbors = 0;
    @JsonProperty(value="alpha")
    public double alpha = 1.0;
    @JsonProperty(value="min_similars")
    public int minSimilars = 1;
    @JsonProperty(value="top")
    public int top = 0;
    @JsonProperty(value="group_property")
    public String groupProperty = null;
    @JsonProperty(value="min_groups")
    public int minGroups = 0;
    @JsonProperty(value="max_degree")
    public long degree = 10000L;
    @JsonProperty(value="capacity")
    public long capacity = 10000000L;
    @JsonProperty(value="limit")
    public long limit = 10L;
    @JsonProperty(value="with_intermediary")
    public boolean withIntermediary = false;
    @JsonProperty(value="with_vertex")
    public boolean withVertex = false;

    private FusiformSimilarityRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("FusiformSimilarityRequest{sourceVertex=%s,label=%s,direction=%s,minNeighbors=%s,alpha=%s,minSimilars=%s,top=%s,groupProperty=%s,minGroups=%s,degree=%s,capacity=%s,limit=%s,withIntermediary=%s,withVertex=%s}", this.sources, this.label, this.direction, this.minNeighbors, this.alpha, this.minSimilars, this.top, this.groupProperty, this.minGroups, this.degree, this.capacity, this.limit, this.withIntermediary, this.withVertex);
    }

    public static class Builder {
        private FusiformSimilarityRequest request = new FusiformSimilarityRequest();
        private VerticesArgs.Builder sourcesBuilder = VerticesArgs.builder();

        private Builder() {
        }

        public VerticesArgs.Builder sources() {
            return this.sourcesBuilder;
        }

        public Builder label(String label) {
            this.request.label = label;
            return this;
        }

        public Builder direction(Direction direction) {
            this.request.direction = direction.toString();
            return this;
        }

        public Builder minNeighbors(int minNeighbors) {
            TraversersAPI.checkPositive(minNeighbors, "min neighbor count");
            this.request.minNeighbors = minNeighbors;
            return this;
        }

        public Builder alpha(double alpha) {
            TraversersAPI.checkAlpha(alpha);
            this.request.alpha = alpha;
            return this;
        }

        public Builder minSimilars(int minSimilars) {
            TraversersAPI.checkPositive(minSimilars, "min similar count");
            this.request.minSimilars = minSimilars;
            return this;
        }

        public Builder top(int top) {
            TraversersAPI.checkPositive(top, "top");
            this.request.top = top;
            return this;
        }

        public Builder groupProperty(String groupProperty) {
            E.checkArgumentNotNull((Object)groupProperty, (String)"The group property can't be null", (Object[])new Object[0]);
            this.request.groupProperty = groupProperty;
            return this;
        }

        public Builder minGroups(int minGroups) {
            TraversersAPI.checkPositive(minGroups, "min group count");
            this.request.minGroups = minGroups;
            return this;
        }

        public Builder degree(long degree) {
            TraversersAPI.checkDegree(degree);
            this.request.degree = degree;
            return this;
        }

        public Builder capacity(long capacity) {
            TraversersAPI.checkCapacity(capacity);
            this.request.capacity = capacity;
            return this;
        }

        public Builder limit(long limit) {
            TraversersAPI.checkLimit(limit);
            this.request.limit = limit;
            return this;
        }

        public Builder withIntermediary(boolean withIntermediary) {
            this.request.withIntermediary = withIntermediary;
            return this;
        }

        public Builder withVertex(boolean withVertex) {
            this.request.withVertex = withVertex;
            return this;
        }

        public FusiformSimilarityRequest build() {
            this.request.sources = this.sourcesBuilder.build();
            E.checkArgument((this.request.sources != null ? 1 : 0) != 0, (String)"Source vertices can't be null", (Object[])new Object[0]);
            TraversersAPI.checkPositive(this.request.minNeighbors, "min neighbor count");
            TraversersAPI.checkPositive(this.request.minSimilars, "min similar count");
            if (this.request.groupProperty != null) {
                TraversersAPI.checkPositive(this.request.minGroups, "min group count");
            }
            TraversersAPI.checkAlpha(this.request.alpha);
            TraversersAPI.checkDegree(this.request.degree);
            TraversersAPI.checkCapacity(this.request.capacity);
            TraversersAPI.checkLimit(this.request.limit);
            return this.request;
        }
    }
}

