/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure.traverser;

import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.structure.traverser.EdgeStep;
import com.baidu.hugegraph.structure.traverser.VerticesArgs;
import com.baidu.hugegraph.util.E;
import com.fasterxml.jackson.annotation.JsonProperty;

public class MultiNodeShortestPathRequest {
    @JsonProperty(value="vertices")
    public VerticesArgs vertices = null;
    @JsonProperty(value="step")
    public EdgeStep step = null;
    @JsonProperty(value="max_depth")
    public int maxDepth = 50;
    @JsonProperty(value="capacity")
    public long capacity = 10000000L;
    @JsonProperty(value="with_vertex")
    public boolean withVertex = false;

    private MultiNodeShortestPathRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("MultiNodeShortestPathRequest{vertices=%s,step=%s,maxDepth=%s,capacity=%s,withVertex=%s}", this.vertices, this.step, this.maxDepth, this.capacity, this.withVertex);
    }

    public static class Builder {
        private MultiNodeShortestPathRequest request = new MultiNodeShortestPathRequest();
        private VerticesArgs.Builder verticesBuilder = VerticesArgs.builder();
        private EdgeStep.Builder stepBuilder = EdgeStep.builder();

        private Builder() {
        }

        public VerticesArgs.Builder vertices() {
            return this.verticesBuilder;
        }

        public EdgeStep.Builder step() {
            EdgeStep.Builder builder;
            this.stepBuilder = builder = EdgeStep.builder();
            return builder;
        }

        public Builder maxDepth(int maxDepth) {
            TraversersAPI.checkPositive(maxDepth, "max depth");
            this.request.maxDepth = maxDepth;
            return this;
        }

        public Builder capacity(long capacity) {
            TraversersAPI.checkCapacity(capacity);
            this.request.capacity = capacity;
            return this;
        }

        public Builder withVertex(boolean withVertex) {
            this.request.withVertex = withVertex;
            return this;
        }

        public MultiNodeShortestPathRequest build() {
            this.request.vertices = this.verticesBuilder.build();
            E.checkArgument((this.request.vertices != null ? 1 : 0) != 0, (String)"The vertices can't be null", (Object[])new Object[0]);
            this.request.step = this.stepBuilder.build();
            E.checkArgument((this.request.step != null ? 1 : 0) != 0, (String)"The step can't be null", (Object[])new Object[0]);
            TraversersAPI.checkPositive(this.request.maxDepth, "max depth");
            TraversersAPI.checkCapacity(this.request.capacity);
            return this.request;
        }
    }
}

