/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure.traverser;

import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.structure.constant.Direction;
import com.baidu.hugegraph.structure.traverser.EdgeStep;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public class RepeatEdgeStep
extends EdgeStep {
    @JsonProperty(value="max_times")
    public int maxTimes = 1;

    private RepeatEdgeStep() {
    }

    public static Builder repeatStepBuilder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return String.format("RepeatEdgeStep{direction=%s,labels=%s,properties=%s,degree=%s,skipDegree=%s,maxTimes=%s}", new Object[]{this.direction, this.labels, this.properties, this.degree, this.skipDegree, this.maxTimes});
    }

    public static class Builder {
        protected RepeatEdgeStep step = new RepeatEdgeStep();

        private Builder() {
        }

        public Builder direction(Direction direction) {
            this.step.direction = direction;
            return this;
        }

        public Builder labels(List<String> labels) {
            this.step.labels = labels;
            return this;
        }

        public Builder labels(String label) {
            this.step.labels.add(label);
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.step.properties = properties;
            return this;
        }

        public Builder properties(String key, Object value) {
            this.step.properties.put(key, value);
            return this;
        }

        public Builder maxTimes(int maxTimes) {
            this.step.maxTimes = maxTimes;
            return this;
        }

        public Builder degree(long degree) {
            TraversersAPI.checkDegree(degree);
            this.step.degree = degree;
            return this;
        }

        public Builder skipDegree(long skipDegree) {
            TraversersAPI.checkSkipDegree(skipDegree, this.step.degree, -1L);
            this.step.skipDegree = skipDegree;
            return this;
        }

        public RepeatEdgeStep build() {
            TraversersAPI.checkDegree(this.step.degree);
            TraversersAPI.checkSkipDegree(this.step.skipDegree, this.step.degree, -1L);
            TraversersAPI.checkPositive(this.step.maxTimes, "max times");
            return this.step;
        }
    }
}

