/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.mojo;

import com.baidu.jprotobuf.mojo.AbstractExecMojo;
import com.baidu.jprotobuf.mojo.ExecutableDependency;
import com.baidu.jprotobuf.mojo.JprotobufPreCompileMain;
import com.baidu.jprotobuf.mojo.Property;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.MavenMetadataSource;

@Mojo(name="precompile", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class PreCompileMojo
extends AbstractExecMojo {
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactMetadataSource metadataSource;
    @Parameter(readonly=true, required=true, defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @Parameter(readonly=true, required=true, defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Component
    private MavenProjectBuilder projectBuilder;
    @Parameter(readonly=true, defaultValue="${plugin.artifacts}")
    private List<Artifact> pluginDependencies;
    private String mainClass = JprotobufPreCompileMain.class.getName();
    private String[] arguments;
    @Parameter
    private Property[] systemProperties;
    @Deprecated
    @Parameter(property="jprotobuf.keepAlive", defaultValue="false")
    private boolean keepAlive;
    @Parameter(property="jprotobuf.includeProjectDependencies", defaultValue="true")
    private boolean includeProjectDependencies;
    @Parameter(property="jprotobuf.includePluginsDependencies", defaultValue="false")
    private boolean includePluginDependencies;
    @Parameter
    private ExecutableDependency executableDependency;
    @Parameter(property="jprotobuf.cleanupDaemonThreads", defaultValue="true")
    private boolean cleanupDaemonThreads;
    @Parameter(property="jprotobuf.daemonThreadJoinTimeout", defaultValue="15000")
    private long daemonThreadJoinTimeout;
    @Parameter(property="jprotobuf.stopUnresponsiveDaemonThreads", defaultValue="false")
    private boolean stopUnresponsiveDaemonThreads;
    @Deprecated
    @Parameter(property="jprotobuf.killAfter", defaultValue="-1")
    private long killAfter;
    private Properties originalSystemProperties;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}")
    protected File outputParentDirectory;
    @Parameter
    private List<String> additionalClasspathElements;
    @Parameter(required=true, property="jprotobuf.filterClassPackage")
    private String filterClassPackage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skipping execute as per configuraion");
            return;
        }
        if (this.killAfter != -1L) {
            this.getLog().warn((CharSequence)"Warning: killAfter is now deprecated. Do you need it ? Please comment on MEXEC-6.");
        }
        this.arguments = new String[]{this.outputParentDirectory.getAbsolutePath(), this.outputDirectory.getAbsolutePath(), this.filterClassPackage};
        if (this.getLog().isDebugEnabled()) {
            StringBuffer msg = new StringBuffer("Invoking : ");
            msg.append(this.mainClass);
            msg.append(".main(");
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(this.arguments[i]);
            }
            msg.append(")");
            this.getLog().debug((CharSequence)msg);
        }
        final Log log = this.getLog();
        IsolatedThreadGroup threadGroup = new IsolatedThreadGroup(this.mainClass);
        Thread bootstrapThread = new Thread(threadGroup, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long current = System.currentTimeMillis();
                try {
                    Method main = Thread.currentThread().getContextClassLoader().loadClass(PreCompileMojo.this.mainClass).getMethod("main", String[].class);
                    if (!main.isAccessible()) {
                        PreCompileMojo.this.getLog().debug((CharSequence)"Setting accessibility to true in order to invoke main().");
                        main.setAccessible(true);
                    }
                    if (!Modifier.isStatic(main.getModifiers())) {
                        throw new MojoExecutionException("Can't call main(String[])-method because it is not static.");
                    }
                    main.invoke(null, new Object[]{PreCompileMojo.this.arguments});
                }
                catch (NoSuchMethodException e) {
                    Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), new Exception("The specified mainClass doesn't contain a main method with appropriate signature.", e));
                }
                catch (Exception e) {
                    Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), e);
                }
                finally {
                    log.info((CharSequence)("JProtobuf pre compile done time took: " + (System.currentTimeMillis() - current) + "ms"));
                }
            }
        }, this.mainClass + ".main()");
        bootstrapThread.setContextClassLoader(this.getClassLoader());
        this.setSystemProperties();
        bootstrapThread.start();
        this.joinNonDaemonThreads(threadGroup);
        if (this.keepAlive) {
            this.getLog().warn((CharSequence)"Warning: keepAlive is now deprecated and obsolete. Do you need it? Please comment on MEXEC-6.");
            this.waitFor(0L);
        }
        if (this.cleanupDaemonThreads) {
            this.terminateThreads(threadGroup);
            try {
                threadGroup.destroy();
            }
            catch (IllegalThreadStateException e) {
                this.getLog().warn((CharSequence)("Couldn't destroy threadgroup " + threadGroup), (Throwable)e);
            }
        }
        if (this.originalSystemProperties != null) {
            System.setProperties(this.originalSystemProperties);
        }
        IsolatedThreadGroup isolatedThreadGroup = threadGroup;
        synchronized (isolatedThreadGroup) {
            if (threadGroup.uncaughtException != null) {
                throw new MojoExecutionException("An exception occured while executing the Java class. " + threadGroup.uncaughtException.getMessage(), threadGroup.uncaughtException);
            }
        }
        this.registerSourceRoots();
    }

    private void joinNonDaemonThreads(ThreadGroup threadGroup) {
        boolean foundNonDaemon;
        do {
            foundNonDaemon = false;
            Collection<Thread> threads = this.getActiveThreads(threadGroup);
            for (Thread thread : threads) {
                if (thread.isDaemon()) continue;
                foundNonDaemon = true;
                this.joinThread(thread, 0L);
            }
        } while (foundNonDaemon);
    }

    private void joinThread(Thread thread, long timeoutMsecs) {
        try {
            this.getLog().debug((CharSequence)("joining on thread " + thread));
            thread.join(timeoutMsecs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.getLog().warn((CharSequence)("interrupted while joining against thread " + thread), (Throwable)e);
        }
        if (thread.isAlive()) {
            this.getLog().warn((CharSequence)("thread " + thread + " was interrupted but is still alive after waiting at least " + timeoutMsecs + "msecs"));
        }
    }

    private void terminateThreads(ThreadGroup threadGroup) {
        long startTime = System.currentTimeMillis();
        HashSet<Thread> uncooperativeThreads = new HashSet<Thread>();
        Collection<Thread> threads = this.getActiveThreads(threadGroup);
        while (!threads.isEmpty()) {
            for (Thread thread : threads) {
                this.getLog().debug((CharSequence)("interrupting thread " + thread));
                thread.interrupt();
            }
            for (Thread thread : threads) {
                if (!thread.isAlive()) continue;
                if (this.daemonThreadJoinTimeout <= 0L) {
                    this.joinThread(thread, 0L);
                    continue;
                }
                long timeout = this.daemonThreadJoinTimeout - (System.currentTimeMillis() - startTime);
                if (timeout > 0L) {
                    this.joinThread(thread, timeout);
                }
                if (!thread.isAlive()) continue;
                uncooperativeThreads.add(thread);
                if (this.stopUnresponsiveDaemonThreads) {
                    this.getLog().warn((CharSequence)("thread " + thread + " will be Thread.stop()'ed"));
                    thread.stop();
                    continue;
                }
                this.getLog().warn((CharSequence)("thread " + thread + " will linger despite being asked to die via interruption"));
            }
            threads = this.getActiveThreads(threadGroup);
            threads.removeAll(uncooperativeThreads);
        }
        if (!uncooperativeThreads.isEmpty()) {
            this.getLog().warn((CharSequence)("NOTE: " + uncooperativeThreads.size() + " thread(s) did not finish despite being asked to  via interruption. This is not a problem with exec:java, it is a problem with the running code. Although not serious, it should be remedied."));
        } else {
            int activeCount = threadGroup.activeCount();
            if (activeCount != 0) {
                Thread[] threadsArray = new Thread[1];
                threadGroup.enumerate(threadsArray);
                this.getLog().debug((CharSequence)("strange; " + activeCount + " thread(s) still active in the group " + threadGroup + " such as " + threadsArray[0]));
            }
        }
    }

    private Collection<Thread> getActiveThreads(ThreadGroup threadGroup) {
        Thread[] threads = new Thread[threadGroup.activeCount()];
        int numThreads = threadGroup.enumerate(threads);
        ArrayList<Thread> result = new ArrayList<Thread>(numThreads);
        for (int i = 0; i < threads.length && threads[i] != null; ++i) {
            result.add(threads[i]);
        }
        return result;
    }

    private void setSystemProperties() {
        if (this.systemProperties != null) {
            this.originalSystemProperties = System.getProperties();
            for (Property systemProperty : this.systemProperties) {
                String value = systemProperty.getValue();
                System.setProperty(systemProperty.getKey(), value == null ? "" : value);
            }
        }
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        ArrayList<URL> classpathURLs = new ArrayList<URL>();
        this.addRelevantPluginDependenciesToClasspath(classpathURLs);
        this.addRelevantProjectDependenciesToClasspath(classpathURLs);
        this.addAdditionalClasspathElements(classpathURLs);
        if (this.outputDirectory.isDirectory()) {
            Collection listFiles = FileUtils.listFiles((File)this.outputDirectory, (String[])new String[]{"class"}, (boolean)true);
            for (Object object : listFiles) {
                File f;
                if (!(object instanceof File) || !(f = (File)object).isFile()) continue;
                try {
                    classpathURLs.add(f.toURI().toURL());
                }
                catch (Exception exception) {}
            }
        }
        return new URLClassLoader(classpathURLs.toArray(new URL[classpathURLs.size()]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void addAdditionalClasspathElements(List<URL> path) {
        if (this.additionalClasspathElements != null) {
            for (String classPathElement : this.additionalClasspathElements) {
                try {
                    File file = new File(classPathElement);
                    if (!file.isAbsolute()) {
                        file = new File(this.project.getBasedir(), classPathElement);
                    }
                    URL url = file.toURI().toURL();
                    this.getLog().debug((CharSequence)("Adding additional classpath element: " + url + " to classpath"));
                    path.add(url);
                }
                catch (MalformedURLException e) {
                    this.getLog().warn((CharSequence)("Skipping additional classpath element: " + classPathElement), (Throwable)e);
                }
            }
        }
    }

    private void addRelevantPluginDependenciesToClasspath(List<URL> path) throws MojoExecutionException {
        if (this.hasCommandlineArgs()) {
            this.arguments = this.parseCommandlineArgs();
        }
        try {
            for (Artifact classPathElement : this.determineRelevantPluginDependencies()) {
                this.getLog().debug((CharSequence)("Adding plugin dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
                path.add(classPathElement.getFile().toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
        }
    }

    private void addRelevantProjectDependenciesToClasspath(List<URL> path) throws MojoExecutionException {
        if (this.includeProjectDependencies) {
            try {
                this.getLog().debug((CharSequence)"Project Dependencies will be included.");
                ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
                ArrayList<File> theClasspathFiles = new ArrayList<File>();
                this.collectProjectArtifactsAndClasspath(artifacts, theClasspathFiles);
                for (File classpathFile : theClasspathFiles) {
                    URL url = classpathFile.toURI().toURL();
                    this.getLog().debug((CharSequence)("Adding to classpath : " + url));
                    path.add(url);
                }
                for (Artifact classPathElement : artifacts) {
                    this.getLog().debug((CharSequence)("Adding project dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
                    path.add(classPathElement.getFile().toURI().toURL());
                }
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
            }
        } else {
            this.getLog().debug((CharSequence)"Project Dependencies will be excluded.");
        }
    }

    private Set<Artifact> determineRelevantPluginDependencies() throws MojoExecutionException {
        Set<Artifact> relevantDependencies;
        if (this.includePluginDependencies) {
            if (this.executableDependency == null) {
                this.getLog().debug((CharSequence)"All Plugin Dependencies will be included.");
                relevantDependencies = new HashSet<Artifact>(this.pluginDependencies);
            } else {
                this.getLog().debug((CharSequence)"Selected plugin Dependencies will be included.");
                Artifact executableArtifact = this.findExecutableArtifact();
                Artifact executablePomArtifact = this.getExecutablePomArtifact(executableArtifact);
                relevantDependencies = this.resolveExecutableDependencies(executablePomArtifact);
            }
        } else {
            relevantDependencies = Collections.emptySet();
            this.getLog().debug((CharSequence)"Plugin Dependencies will be excluded.");
        }
        return relevantDependencies;
    }

    private Artifact getExecutablePomArtifact(Artifact executableArtifact) {
        return this.artifactFactory.createBuildArtifact(executableArtifact.getGroupId(), executableArtifact.getArtifactId(), executableArtifact.getVersion(), "pom");
    }

    private Artifact findExecutableArtifact() throws MojoExecutionException {
        Artifact executableTool = null;
        for (Artifact pluginDep : this.pluginDependencies) {
            if (!this.executableDependency.matches(pluginDep)) continue;
            executableTool = pluginDep;
            break;
        }
        if (executableTool == null) {
            throw new MojoExecutionException("No dependency of the plugin matches the specified executableDependency.  Specified executableToolAssembly is: " + this.executableDependency.toString());
        }
        return executableTool;
    }

    private Set<Artifact> resolveExecutableDependencies(Artifact executablePomArtifact) throws MojoExecutionException {
        Set executableDependencies;
        try {
            MavenProject executableProject = this.projectBuilder.buildFromRepository(executablePomArtifact, this.remoteRepositories, this.localRepository);
            List dependencies = executableProject.getDependencies();
            Set dependencyArtifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, (List)dependencies, null, null, null);
            dependencyArtifacts.add(executableProject.getArtifact());
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(dependencyArtifacts, executablePomArtifact, Collections.emptyMap(), this.localRepository, this.remoteRepositories, this.metadataSource, null, Collections.emptyList());
            executableDependencies = result.getArtifacts();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Encountered problems resolving dependencies of the executable in preparation for its execution.", ex);
        }
        return executableDependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(long millis) {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait(millis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.getLog().warn((CharSequence)("Spuriously interrupted while waiting for " + millis + "ms"), (Throwable)e);
            }
        }
    }

    class IsolatedThreadGroup
    extends ThreadGroup {
        private Throwable uncaughtException;

        public IsolatedThreadGroup(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                return;
            }
            IsolatedThreadGroup isolatedThreadGroup = this;
            synchronized (isolatedThreadGroup) {
                if (this.uncaughtException == null) {
                    this.uncaughtException = throwable;
                }
            }
            PreCompileMojo.this.getLog().warn(throwable);
        }
    }
}

