/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.mojo;

import com.baidu.bjf.remoting.protobuf.ProtobufIDLGenerator;
import com.baidu.bjf.remoting.protobuf.ProtobufProxy;
import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;
import com.baidu.bjf.remoting.protobuf.annotation.ProtobufClass;
import com.baidu.bjf.remoting.protobuf.utils.FieldUtils;
import com.baidu.bjf.remoting.protobuf.utils.JDKCompilerHelper;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import com.baidu.bjf.remoting.protobuf.utils.compiler.Compiler;
import com.baidu.bjf.remoting.protobuf.utils.compiler.JdkCompiler;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import jodd.io.findfile.ClassFinder;
import jodd.io.findfile.ClassScanner;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JprotobufPreCompileMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(JprotobufPreCompileMain.class);
    private static final String MULTI_PKG_SPLIT = ";";

    public static void main(String[] args) {
        block6: {
            if (args == null || args.length == 0 || args.length != 4) {
                throw new RuntimeException(JprotobufPreCompileMain.printUsage());
            }
            final File outputPath = new File(String.valueOf(args[0]) + File.separator + "temp");
            try {
                FileUtils.deleteDirectory((File)outputPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            outputPath.mkdirs();
            JDKCompilerHelper.setCompiler((Compiler)new JdkCompiler(Thread.currentThread().getContextClassLoader()));
            String filterClassPackage = args[2];
            if (filterClassPackage == null) {
                LOGGER.error("filterClassPackage setting is null.");
                return;
            }
            final String[] split = filterClassPackage.split(MULTI_PKG_SPLIT);
            final boolean generateProtofile = Boolean.valueOf(args[3]);
            ClassScanner scanner = new ClassScanner(){

                protected void onEntry(ClassFinder.EntryData entryData) throws Exception {
                    String name = entryData.getName();
                    if (!JprotobufPreCompileMain.isStartWith(name, split)) {
                        return;
                    }
                    Class c = JprotobufPreCompileMain.getByClass(name);
                    if (c == null) {
                        return;
                    }
                    if (Enum.class.isAssignableFrom(c)) {
                        return;
                    }
                    ProtobufClass annotation = c.getAnnotation(ProtobufClass.class);
                    if (annotation != null) {
                        try {
                            ProtobufProxy.create((Class)c, (boolean)false, (File)outputPath);
                            if (generateProtofile) {
                                JprotobufPreCompileMain.createProtoFile(c, outputPath.getCanonicalPath());
                            }
                        }
                        catch (Throwable e) {
                            throw new Exception(e.getMessage(), e);
                        }
                        return;
                    }
                    try {
                        List fields = FieldUtils.findMatchedFields((Class)c, Protobuf.class);
                        if (!fields.isEmpty()) {
                            ProtobufProxy.create((Class)c, (boolean)false, (File)outputPath);
                            if (generateProtofile) {
                                JprotobufPreCompileMain.createProtoFile(c, outputPath.getCanonicalPath());
                            }
                        }
                    }
                    catch (Throwable e) {
                        throw new Exception(e.getMessage(), e);
                    }
                }
            };
            scanner.scanDefaultClasspath();
            try {
                FileUtils.copyDirectory((File)outputPath, (File)new File(args[1]));
            }
            catch (IOException e) {
                if (!LOGGER.isDebugEnabled()) break block6;
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void createProtoFile(Class c, String outputPath) throws UnsupportedEncodingException, IOException {
        String code = ProtobufIDLGenerator.getIDL((Class)c);
        String pkg = "";
        String className = c.getName();
        if (className.indexOf(46) != -1) {
            pkg = StringUtils.substringBeforeLast((String)className, (String)".");
        }
        String dir = String.valueOf(outputPath) + File.separator + pkg.replace('.', File.separatorChar);
        File f = new File(dir);
        f.mkdirs();
        String fileName = String.valueOf(c.getSimpleName()) + ".proto";
        File file = new File(dir, fileName);
        LOGGER.info("Generate proto file to " + file.getAbsolutePath());
        FileUtils.writeByteArrayToFile((File)file, (byte[])code.getBytes("utf-8"));
    }

    private static String printUsage() {
        return "Usage: " + JprotobufPreCompileMain.class.getName() + " outputFile";
    }

    private static boolean isStartWith(String testString, String[] targetStrings) {
        String[] stringArray = targetStrings;
        int n = targetStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (testString.startsWith(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static Class getByClass(String name) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Throwable e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), e);
            }
            return null;
        }
    }
}

