/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.mojo;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public abstract class AbstractExecMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="sourceRoot")
    private File sourceRoot;
    @Parameter(property="testSourceRoot")
    private File testSourceRoot;
    @Parameter(property="exec.args")
    private String commandlineArgs;
    @Parameter(property="exec.classpathScope", defaultValue="runtime")
    protected String classpathScope;
    @Parameter(property="exec.skip", defaultValue="false", alias="skip")
    private boolean skip;

    protected void collectProjectArtifactsAndClasspath(List<Artifact> artifacts, List<File> theClasspathFiles) {
        if ("compile".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getCompileArtifacts());
            theClasspathFiles.add(new File(this.project.getBuild().getOutputDirectory()));
        } else if ("test".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getTestArtifacts());
            theClasspathFiles.add(new File(this.project.getBuild().getTestOutputDirectory()));
            theClasspathFiles.add(new File(this.project.getBuild().getOutputDirectory()));
        } else if ("runtime".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getRuntimeArtifacts());
            theClasspathFiles.add(new File(this.project.getBuild().getOutputDirectory()));
        } else if ("system".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getSystemArtifacts());
        } else {
            throw new IllegalStateException("Invalid classpath scope: " + this.classpathScope);
        }
        this.getLog().debug((CharSequence)("Collected project artifacts " + artifacts));
        this.getLog().debug((CharSequence)("Collected project classpath " + theClasspathFiles));
    }

    protected String[] parseCommandlineArgs() throws MojoExecutionException {
        if (this.commandlineArgs == null) {
            return null;
        }
        try {
            return CommandLineUtils.translateCommandline((String)this.commandlineArgs);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    protected boolean hasCommandlineArgs() {
        return this.commandlineArgs != null;
    }

    protected void registerSourceRoots() {
        if (this.sourceRoot != null) {
            this.getLog().info((CharSequence)("Registering compile source root " + this.sourceRoot));
            this.project.addCompileSourceRoot(this.sourceRoot.toString());
        }
        if (this.testSourceRoot != null) {
            this.getLog().info((CharSequence)("Registering compile test source root " + this.testSourceRoot));
            this.project.addTestCompileSourceRoot(this.testSourceRoot.toString());
        }
    }

    protected boolean isSkip() {
        return this.skip;
    }
}

