/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.client.ha.lb;

import com.baidu.jprotobuf.pbrpc.client.ha.lb.ServiceMultiInterfaceAccessor;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.failover.FailOverEvent;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.failover.FailOverInterceptor;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.failover.RecoverHeartbeat;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.strategy.LoadBalanceStrategy;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.strategy.RoundRobinLoadBalanceStrategy;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.strategy.StrategyInterceptor;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;

public class LoadBalanceProxyFactoryBean
extends ServiceMultiInterfaceAccessor
implements BeanClassLoaderAware,
FactoryBean,
InitializingBean,
MethodInterceptor,
DisposableBean,
BeanNameAware {
    private static final int DEFAULT_LB_FACTOR = 1;
    private static final Logger LOGGER = Logger.getLogger(LoadBalanceProxyFactoryBean.class.getName());
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Map<String, Object> targetBeans;
    private Object serviceProxy;
    private LoadBalanceStrategy loadBalanceStrategy;
    private FailOverInterceptor failOverInterceptor;
    private Map<String, FactoryBeanInvokeInfo> failedFactoryBeans = new ConcurrentHashMap<String, FactoryBeanInvokeInfo>();
    private RecoverHeartbeat recoverHeartbeat;
    private FailOverEvent failOverEvent;
    private StrategyInterceptor strategyInterceptor;
    private boolean heartBeat = true;
    private long recoverInterval = 1000L;
    private String beanName = "";
    private Throwable lastestException;
    private ExecutorService exe = Executors.newFixedThreadPool(1, (ThreadFactory)new DefaultThreadFactory("loadbalance-heartbeat"));

    public void setFailOverEvent(FailOverEvent failOverEvent) {
        this.failOverEvent = failOverEvent;
    }

    public void setTargetBeans(Map<String, Object> targetFactoryBeans) {
        this.targetBeans = targetFactoryBeans;
    }

    public synchronized void addTargetBean(String key, Object targetBean) {
        if (this.targetBeans == null) {
            this.targetBeans = new ConcurrentHashMap<String, Object>();
        }
        this.targetBeans.put(key, targetBean);
    }

    public void setLoadBalanceStrategy(LoadBalanceStrategy loadBalanceStrategy) {
        this.loadBalanceStrategy = loadBalanceStrategy;
    }

    public FailOverInterceptor getFailOverInterceptor() {
        return this.failOverInterceptor;
    }

    public void setFailOverInterceptor(FailOverInterceptor failOverInterceptor) {
        this.failOverInterceptor = failOverInterceptor;
    }

    public boolean isFailOver() {
        return this.failOverInterceptor != null;
    }

    private boolean isAssignableFrom(List<Class> interfaces, Class clazz) {
        if (interfaces == null) {
            return true;
        }
        for (Class c : interfaces) {
            if (c.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void afterPropertiesSet() throws Exception {
        if (this.getServiceInterface() == null) {
            throw new IllegalArgumentException("Property 'serviceInterfaces' is required");
        }
        if (this.targetBeans == null) {
            throw new IllegalArgumentException("Property 'targetFactoryBeans' is required");
        }
        for (Map.Entry<String, Object> entry : this.targetBeans.entrySet()) {
            Object o = entry.getValue();
            if (!this.getServiceInterface().isAssignableFrom(o.getClass())) {
                throw new IllegalArgumentException("target facotry bean class '" + entry.getKey() + "' must implement serviceInterface");
            }
            if (this.isAssignableFrom(this.getExtraServiceInterfaces(), o.getClass())) continue;
            throw new IllegalArgumentException("target facotry bean class '" + entry.getKey() + "' must implement all the extraInterfaces ");
        }
        ProxyFactory pf = new ProxyFactory(this.getServiceInterface(), (Interceptor)this);
        if (this.getExtraServiceInterfaces() != null) {
            for (Class clazz : this.getExtraServiceInterfaces()) {
                pf.addInterface(clazz);
            }
        }
        this.serviceProxy = pf.getProxy(this.getBeanClassLoader());
        if (this.loadBalanceStrategy == null) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (String key : this.targetBeans.keySet()) {
                hashMap.put(key, 1);
            }
            this.loadBalanceStrategy = new RoundRobinLoadBalanceStrategy(hashMap);
        } else {
            void var2_8;
            Set<String> set = this.loadBalanceStrategy.getTargets();
            if (set == null) {
                HashSet hashSet = new HashSet();
            }
            for (String key : var2_8) {
                if (this.targetBeans.containsKey(key)) continue;
                LOGGER.log(Level.SEVERE, "the target key '" + key + "' of loadBalanceStrategy is invalid");
                this.loadBalanceStrategy.removeTarget(key);
            }
        }
        this.targetBeans = Collections.synchronizedMap(this.targetBeans);
        if (!this.isFailOver()) {
            LOGGER.log(Level.WARNING, "LoadBalanceProxy is shut down failover action due to not set FailOverInterceptor");
        }
    }

    public Object getObject() {
        return this.serviceProxy;
    }

    public Class getObjectType() {
        return this.getServiceInterface();
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    private void failedTarget(Object bean, MethodInvocation invocation, String beanKey) throws Throwable {
        this.loadBalanceStrategy.removeTarget(beanKey);
        FactoryBeanInvokeInfo info = new FactoryBeanInvokeInfo(bean, this.getMethod(bean, invocation), beanKey);
        this.failedFactoryBeans.put(beanKey, info);
        this.executeHeartBeat();
        if (this.failOverEvent != null) {
            this.failOverEvent.onTargetFailed(beanKey, bean, invocation);
        }
        if (this.strategyInterceptor != null) {
            this.strategyInterceptor.onTargetFailed(beanKey, bean, invocation);
        }
    }

    private String elect(MethodInvocation invocation) {
        String key = null;
        if (this.strategyInterceptor != null) {
            this.strategyInterceptor.beforeElection(this.loadBalanceStrategy, invocation);
            if (!this.strategyInterceptor.isDoElection(invocation)) {
                key = this.strategyInterceptor.elect(invocation);
            }
        }
        if (key == null) {
            try {
                key = this.loadBalanceStrategy.elect();
            }
            catch (Exception e) {
                String message = "A error found: " + e.getMessage() + "";
                if (this.lastestException != null) {
                    message = message + " with last exception message:" + this.lastestException.getMessage();
                }
                throw new RuntimeException(message, e);
            }
        }
        if (this.strategyInterceptor != null) {
            this.strategyInterceptor.afterElection(key, invocation);
        }
        return key;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        int maxTry = this.loadBalanceStrategy.getTargets().size();
        return this.invokeWithMaxTry(invocation, maxTry);
    }

    public Object invokeWithMaxTry(MethodInvocation invocation, int maxTry) throws Throwable {
        String beanKey = this.elect(invocation);
        Object bean = this.targetBeans.get(beanKey);
        if (this.isFailOver()) {
            boolean isAvailable;
            try {
                isAvailable = this.failOverInterceptor.isAvailable(bean, this.getMethod(bean, invocation), beanKey);
            }
            catch (Exception e) {
                isAvailable = false;
            }
            if (!isAvailable) {
                this.failedTarget(bean, invocation, beanKey);
                return this.invokeWithMaxTry(invocation, maxTry);
            }
        }
        if (bean != null) {
            try {
                return this.doInvoke(bean, invocation);
            }
            catch (Throwable e) {
                Throwable t;
                this.lastestException = t = this.getRealException(e);
                if (this.isFailOver() && this.failOverInterceptor.isDoFailover(t, beanKey)) {
                    LOGGER.log(Level.SEVERE, "do failover action due to last access throws exception: " + t.getLocalizedMessage());
                    this.failedTarget(bean, invocation, beanKey);
                    if (--maxTry < 1) {
                        throw t;
                    }
                    return this.invokeWithMaxTry(invocation, maxTry);
                }
                throw t;
            }
        }
        throw new NullPointerException("target bean is null");
    }

    private Throwable getRealException(Throwable t) {
        do {
            if (t instanceof UndeclaredThrowableException) {
                t = ((UndeclaredThrowableException)t).getCause();
            }
            if (!(t instanceof InvocationTargetException)) continue;
            t = ((InvocationTargetException)t).getTargetException();
        } while (t instanceof UndeclaredThrowableException || t instanceof InvocationTargetException);
        return t;
    }

    private Object doInvoke(Object bean, MethodInvocation invocation) throws Throwable {
        Object[] args = invocation.getArguments();
        Method m = this.getMethod(bean, invocation);
        return m.invoke(bean, args);
    }

    private Method getMethod(Object bean, MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        if (bean == null) {
            System.out.println("error");
        }
        Class<?> cls = bean.getClass();
        Method m = cls.getMethod(methodName, invocation.getMethod().getParameterTypes());
        return m;
    }

    public Map<String, FactoryBeanInvokeInfo> getFailedFactoryBeans() {
        return this.failedFactoryBeans;
    }

    public synchronized void recoverFactoryBean(String key) {
        if (this.failedFactoryBeans.containsKey(key)) {
            this.failedFactoryBeans.remove(key);
            this.loadBalanceStrategy.recoverTarget(key);
            if (this.failOverEvent != null) {
                this.failOverEvent.onTargetRecover(key);
            }
            if (this.strategyInterceptor != null) {
                this.strategyInterceptor.onTargetRecover(key);
            }
        }
    }

    public synchronized boolean hasFactoryBeanFailed() {
        return !this.failedFactoryBeans.isEmpty();
    }

    private synchronized void executeHeartBeat() {
        if (!this.isHeartBeat()) {
            return;
        }
        if (this.recoverHeartbeat == null) {
            this.recoverHeartbeat = new RecoverHeartbeat(this);
            this.exe.execute(this.recoverHeartbeat);
        } else if (!this.recoverHeartbeat.isRuning()) {
            this.exe.execute(this.recoverHeartbeat);
        }
    }

    public void destroy() throws Exception {
        this.cleanResource(true);
    }

    public void cleanResource(boolean needFreeThreadPool) {
        if (this.recoverHeartbeat != null) {
            this.recoverHeartbeat.close();
        }
        if (needFreeThreadPool && this.exe != null) {
            this.exe.shutdown();
            this.exe = null;
        }
        this.targetBeans.clear();
        this.failedFactoryBeans.clear();
    }

    public void setStrategyInterceptor(StrategyInterceptor strategyInterceptor) {
        this.strategyInterceptor = strategyInterceptor;
    }

    public void setRecoverInterval(long recoverInterval) {
        this.recoverInterval = recoverInterval;
    }

    public long getRecoverInterval() {
        return this.recoverInterval;
    }

    protected boolean isHeartBeat() {
        return this.heartBeat;
    }

    public void setHeartBeat(boolean heartBeat) {
        this.heartBeat = heartBeat;
        if (!heartBeat) {
            LOGGER.log(Level.WARNING, "LoadBalance heartbeat is set to disabled");
        }
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public static class FactoryBeanInvokeInfo {
        private Object bean;
        private Method m;
        private String beanKey;

        public FactoryBeanInvokeInfo(Object bean, Method m, String beanKey) {
            this.bean = bean;
            this.m = m;
            this.beanKey = beanKey;
        }

        public Object getBean() {
            return this.bean;
        }

        public Method getInvocation() {
            return this.m;
        }

        public String getBeanKey() {
            return this.beanKey;
        }
    }
}

