/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.spring.annotation;

import com.baidu.bjf.remoting.protobuf.utils.JDKCompilerHelper;
import com.baidu.bjf.remoting.protobuf.utils.compiler.Compiler;
import com.baidu.jprotobuf.pbrpc.client.ha.NamingService;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.failover.SocketFailOverInterceptor;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.strategy.NamingServiceLoadBalanceStrategyFactory;
import com.baidu.jprotobuf.pbrpc.intercept.InvokerInterceptor;
import com.baidu.jprotobuf.pbrpc.registry.RegistryCenterService;
import com.baidu.jprotobuf.pbrpc.spring.HaRpcProxyFactoryBean;
import com.baidu.jprotobuf.pbrpc.spring.RpcProxyFactoryBean;
import com.baidu.jprotobuf.pbrpc.spring.RpcServiceExporter;
import com.baidu.jprotobuf.pbrpc.spring.annotation.AbstractAnnotationParserCallback;
import com.baidu.jprotobuf.pbrpc.spring.annotation.HaRpcProxy;
import com.baidu.jprotobuf.pbrpc.spring.annotation.ProtobufRpcAnnotationRessolverListener;
import com.baidu.jprotobuf.pbrpc.spring.annotation.RpcExporter;
import com.baidu.jprotobuf.pbrpc.spring.annotation.RpcProxy;
import com.baidu.jprotobuf.pbrpc.transport.RpcClientOptions;
import com.baidu.jprotobuf.pbrpc.transport.RpcServerOptions;
import com.baidu.jprotobuf.pbrpc.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class ProtobufRpcAnnotationResolver
extends AbstractAnnotationParserCallback
implements InitializingBean {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ProtobufRpcAnnotationResolver.class);
    private List<RpcProxyFactoryBean> rpcClients = new ArrayList<RpcProxyFactoryBean>();
    private List<HaRpcProxyFactoryBean> haRpcClients = new ArrayList<HaRpcProxyFactoryBean>();
    private Map<Integer, RpcServiceExporter> portMappingExpoters = new HashMap<Integer, RpcServiceExporter>();
    private NamingServiceLoadBalanceStrategyFactory namingServiceLoadBalanceStrategyFactory;
    private SocketFailOverInterceptor failOverInterceptor;
    private Compiler compiler;
    private AtomicBoolean started = new AtomicBoolean(false);
    private RegistryCenterService registryCenterService;
    private InvokerInterceptor clientInterceptor;
    private ProtobufRpcAnnotationRessolverListener protobufRpcAnnotationRessolverListener;
    private InvokerInterceptor serverInterceptor;

    public void setProtobufRpcAnnotationRessolverListener(ProtobufRpcAnnotationRessolverListener protobufRpcAnnotationRessolverListener) {
        this.protobufRpcAnnotationRessolverListener = protobufRpcAnnotationRessolverListener;
    }

    public void setClientInterceptor(InvokerInterceptor clientInterceptor) {
        this.clientInterceptor = clientInterceptor;
    }

    public void setServerInterceptor(InvokerInterceptor serverInterceptor) {
        this.serverInterceptor = serverInterceptor;
    }

    public void setNamingServiceLoadBalanceStrategyFactory(NamingServiceLoadBalanceStrategyFactory namingServiceLoadBalanceStrategyFactory) {
        this.namingServiceLoadBalanceStrategyFactory = namingServiceLoadBalanceStrategyFactory;
    }

    public void setFailOverInterceptor(SocketFailOverInterceptor failOverInterceptor) {
        this.failOverInterceptor = failOverInterceptor;
    }

    public void setRegistryCenterService(RegistryCenterService registryCenterService) {
        this.registryCenterService = registryCenterService;
    }

    @Override
    public Object annotationAtType(Annotation t, Object bean, String beanName, ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (t instanceof RpcExporter) {
            LOGGER.info("Annotation 'RpcExporter' for target '" + beanName + "' created");
            this.parseRpcExporterAnnotation((RpcExporter)t, beanFactory, beanFactory.getBean(beanName));
        }
        return bean;
    }

    private void parseRpcExporterAnnotation(RpcExporter rpcExporter, ConfigurableListableBeanFactory beanFactory, Object bean) {
        List<Object> registerServices;
        String port = this.parsePlaceholder(rpcExporter.port());
        int intPort = Integer.valueOf(port);
        String host = this.parsePlaceholder(rpcExporter.host());
        boolean isNeedStart = false;
        RpcServiceExporter rpcServiceExporter = this.portMappingExpoters.get(intPort);
        if (rpcServiceExporter == null) {
            rpcServiceExporter = new RpcServiceExporter();
            isNeedStart = true;
            String rpcServerOptionsBeanName = this.parsePlaceholder(rpcExporter.rpcServerOptionsBeanName());
            RpcServerOptions rpcServerOptions = StringUtils.isBlank((String)rpcServerOptionsBeanName) ? new RpcServerOptions() : (RpcServerOptions)beanFactory.getBean(rpcServerOptionsBeanName, RpcServerOptions.class);
            String interceptorName = this.parsePlaceholder(rpcExporter.invokerIntercepterBeanName());
            if (!StringUtils.isBlank((String)interceptorName)) {
                InvokerInterceptor interceptor = (InvokerInterceptor)beanFactory.getBean(interceptorName, InvokerInterceptor.class);
                rpcServiceExporter.setInterceptor(interceptor);
            } else if (this.serverInterceptor != null) {
                rpcServiceExporter.setInterceptor(this.serverInterceptor);
            }
            rpcServiceExporter.setServicePort(intPort);
            rpcServiceExporter.setHost(host);
            rpcServiceExporter.copyFrom(rpcServerOptions);
            rpcServiceExporter.setRegistryCenterService(this.registryCenterService);
            this.portMappingExpoters.put(intPort, rpcServiceExporter);
        }
        if ((registerServices = rpcServiceExporter.getRegisterServices()) == null) {
            registerServices = new ArrayList<Object>();
        }
        registerServices.add(bean);
        if (this.protobufRpcAnnotationRessolverListener != null) {
            this.protobufRpcAnnotationRessolverListener.onRpcExporterAnnotationParsered(rpcExporter, intPort, bean, registerServices);
        }
        rpcServiceExporter.setRegisterServices(registerServices);
        if (isNeedStart) {
            try {
                rpcServiceExporter.afterPropertiesSet();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void annotationAtTypeAfterStarted(Annotation t, Object bean, String beanName, ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    @Override
    public Object annotationAtField(Annotation t, Object value, String beanName, PropertyValues pvs, ConfigurableListableBeanFactory beanFactory, Field field) throws BeansException {
        if (t instanceof RpcProxy) {
            try {
                LOGGER.info("Annotation 'RpcProxy' on field '" + field.getName() + "' for target '" + beanName + "' created");
                return this.parseRpcProxyAnnotation((RpcProxy)t, beanFactory);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (t instanceof HaRpcProxy) {
            try {
                LOGGER.info("Annotation 'HaRpcProxy' on field '" + field.getName() + "' for target '" + beanName + "' created");
                return this.parseHaRpcProxyAnnotation((HaRpcProxy)t, beanFactory);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return value;
    }

    private Object parseHaRpcProxyAnnotation(HaRpcProxy rpcProxy, ConfigurableListableBeanFactory beanFactory) throws Exception {
        String interceptorName;
        String namingServiceBeanName = this.parsePlaceholder(rpcProxy.namingServiceBeanName());
        NamingService namingService = (NamingService)beanFactory.getBean(namingServiceBeanName, NamingService.class);
        String rpcClientOptionsBeanName = this.parsePlaceholder(rpcProxy.rpcClientOptionsBeanName());
        RpcClientOptions rpcClientOptions = StringUtils.isBlank((String)rpcClientOptionsBeanName) ? new RpcClientOptions() : (RpcClientOptions)beanFactory.getBean(rpcClientOptionsBeanName, RpcClientOptions.class);
        HaRpcProxyFactoryBean haRpcProxyFactoryBean = new HaRpcProxyFactoryBean();
        haRpcProxyFactoryBean.copyFrom(rpcClientOptions);
        haRpcProxyFactoryBean.setNamingService(namingService);
        haRpcProxyFactoryBean.setServiceInterface(rpcProxy.serviceInterface());
        haRpcProxyFactoryBean.setLookupStubOnStartup(rpcProxy.lookupStubOnStartup());
        String failoverInteceptorBeanName = this.parsePlaceholder(rpcProxy.failoverInteceptorBeanName());
        if (!StringUtils.isBlank((String)failoverInteceptorBeanName)) {
            SocketFailOverInterceptor failOverInterceptor = (SocketFailOverInterceptor)beanFactory.getBean(failoverInteceptorBeanName, SocketFailOverInterceptor.class);
            haRpcProxyFactoryBean.setFailOverInterceptor(failOverInterceptor);
        } else if (this.failOverInterceptor != null) {
            haRpcProxyFactoryBean.setFailOverInterceptor(this.failOverInterceptor);
        }
        if (this.namingServiceLoadBalanceStrategyFactory != null) {
            haRpcProxyFactoryBean.setNamingServiceLoadBalanceStrategyFactory(this.namingServiceLoadBalanceStrategyFactory);
        }
        if (!StringUtils.isBlank((String)(interceptorName = this.parsePlaceholder(rpcProxy.invokerIntercepterBeanName())))) {
            InvokerInterceptor interceptor = (InvokerInterceptor)beanFactory.getBean(interceptorName, InvokerInterceptor.class);
            haRpcProxyFactoryBean.setInterceptor(interceptor);
        } else if (this.clientInterceptor != null) {
            haRpcProxyFactoryBean.setInterceptor(this.clientInterceptor);
        }
        haRpcProxyFactoryBean.afterPropertiesSet();
        this.haRpcClients.add(haRpcProxyFactoryBean);
        return haRpcProxyFactoryBean.getObject();
    }

    private Object parseRpcProxyAnnotation(RpcProxy rpcProxy, ConfigurableListableBeanFactory beanFactory) throws Exception {
        String rpcClientOptionsBeanName = this.parsePlaceholder(rpcProxy.rpcClientOptionsBeanName());
        RpcClientOptions rpcClientOptions = StringUtils.isBlank((String)rpcClientOptionsBeanName) ? new RpcClientOptions() : (RpcClientOptions)beanFactory.getBean(rpcClientOptionsBeanName, RpcClientOptions.class);
        String port = this.parsePlaceholder(rpcProxy.port());
        int intPort = Integer.valueOf(port);
        String host = this.parsePlaceholder(rpcProxy.host());
        RpcProxyFactoryBean rpcProxyFactoryBean = this.createRpcProxyFactoryBean(rpcProxy, beanFactory, rpcClientOptions, intPort, host);
        rpcProxyFactoryBean.afterPropertiesSet();
        this.rpcClients.add(rpcProxyFactoryBean);
        Object object = rpcProxyFactoryBean.getObject();
        if (this.protobufRpcAnnotationRessolverListener != null) {
            RpcProxyFactoryBean newRpcProxyFactoryBean = this.createRpcProxyFactoryBean(rpcProxy, beanFactory, rpcClientOptions, intPort, host);
            this.protobufRpcAnnotationRessolverListener.onRpcProxyAnnotationParsed(rpcProxy, newRpcProxyFactoryBean, rpcProxyFactoryBean.getProxyBean());
        }
        return object;
    }

    protected RpcProxyFactoryBean createRpcProxyFactoryBean(RpcProxy rpcProxy, ConfigurableListableBeanFactory beanFactory, RpcClientOptions rpcClientOptions, int intPort, String host) {
        RpcProxyFactoryBean rpcProxyFactoryBean = new RpcProxyFactoryBean();
        rpcProxyFactoryBean.copyFrom(rpcClientOptions);
        rpcProxyFactoryBean.setServiceInterface(rpcProxy.serviceInterface());
        rpcProxyFactoryBean.setPort(intPort);
        rpcProxyFactoryBean.setHost(host);
        rpcProxyFactoryBean.setLookupStubOnStartup(rpcProxy.lookupStubOnStartup());
        String interceptorName = this.parsePlaceholder(rpcProxy.invokerIntercepterBeanName());
        if (!StringUtils.isBlank((String)interceptorName)) {
            InvokerInterceptor interceptor = (InvokerInterceptor)beanFactory.getBean(interceptorName, InvokerInterceptor.class);
            rpcProxyFactoryBean.setInterceptor(interceptor);
        } else if (this.clientInterceptor != null) {
            rpcProxyFactoryBean.setInterceptor(this.clientInterceptor);
        }
        return rpcProxyFactoryBean;
    }

    @Override
    public Object annotationAtMethod(Annotation t, Object bean, String beanName, PropertyValues pvs, ConfigurableListableBeanFactory beanFactory, Method method) throws BeansException {
        if (t instanceof RpcProxy) {
            try {
                LOGGER.info("Annotation 'RpcProxy' on method '" + method.getName() + "' for target '" + beanName + "' created");
                return this.parseRpcProxyAnnotation((RpcProxy)t, beanFactory);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (t instanceof HaRpcProxy) {
            try {
                LOGGER.info("Annotation 'HaRpcProxy' on method '" + method.getName() + "' for target '" + beanName + "' created");
                return this.parseHaRpcProxyAnnotation((HaRpcProxy)t, beanFactory);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    public Class<? extends Annotation> getTypeAnnotation() {
        return RpcExporter.class;
    }

    @Override
    public List<Class<? extends Annotation>> getMethodFieldAnnotation() {
        ArrayList<Class<? extends Annotation>> list = new ArrayList<Class<? extends Annotation>>();
        list.add(RpcProxy.class);
        list.add(HaRpcProxy.class);
        return list;
    }

    @Override
    public void destroy() throws Exception {
        if (this.rpcClients != null) {
            for (RpcProxyFactoryBean rpcProxyFactoryBean : this.rpcClients) {
                try {
                    rpcProxyFactoryBean.destroy();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), e.getCause());
                }
            }
        }
        if (this.haRpcClients != null) {
            for (HaRpcProxyFactoryBean haRpcProxyFactoryBean : this.haRpcClients) {
                try {
                    haRpcProxyFactoryBean.destroy();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), e.getCause());
                }
            }
        }
        if (this.portMappingExpoters != null) {
            Collection<RpcServiceExporter> exporters = this.portMappingExpoters.values();
            for (RpcServiceExporter rpcServiceExporter : exporters) {
                try {
                    rpcServiceExporter.destroy();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), e.getCause());
                }
            }
        }
        if (this.protobufRpcAnnotationRessolverListener != null) {
            this.protobufRpcAnnotationRessolverListener.destroy();
        }
    }

    public void setCompiler(Compiler compiler) {
        this.compiler = compiler;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.compiler != null) {
            JDKCompilerHelper.setCompiler((Compiler)this.compiler);
        }
    }
}

