/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.spring.meta;

import com.baidu.jprotobuf.pbrpc.meta.MetaExportHelper;
import com.baidu.jprotobuf.pbrpc.utils.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class RpcMetaExporter
implements ApplicationListener,
InitializingBean {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RpcMetaExporter.class);
    private int servicePort;
    private String serviceHost;
    private String path;
    private File localFile;
    private AtomicBoolean started = new AtomicBoolean(false);

    public void setPath(String path) {
        this.path = path;
    }

    public void setServicePort(int servicePort) {
        this.servicePort = servicePort;
    }

    public void setServiceHost(String serviceHost) {
        this.serviceHost = serviceHost;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            if (this.started.compareAndSet(false, true)) {
                this.doExport();
            } else {
                LOGGER.warn("onApplicationEvent of application event [" + event + "] ignored due to processor already started.");
            }
        }
    }

    private void doExport() {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.localFile);
            String idl = MetaExportHelper.exportIDL((String)this.serviceHost, (int)this.servicePort);
            fos.write(idl.getBytes("utf-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        boolean createNewFile;
        if (StringUtils.isBlank((String)this.path)) {
            throw new IllegalArgumentException("Property 'path' is blank.");
        }
        if (this.servicePort <= 0) {
            throw new IllegalArgumentException("Property 'servicePort' is invalid port value is: " + this.servicePort);
        }
        this.localFile = new File(this.path);
        if (!this.localFile.exists() && !(createNewFile = this.localFile.createNewFile())) {
            throw new IllegalArgumentException("Property 'path' is invalid path value is: " + this.path);
        }
    }
}

