/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.client;

import com.baidu.jprotobuf.pbrpc.AuthenticationDataHandler;
import com.baidu.jprotobuf.pbrpc.ClientAttachmentHandler;
import com.baidu.jprotobuf.pbrpc.DummyAuthenticationDataHandler;
import com.baidu.jprotobuf.pbrpc.DummyClientAttachmentHandler;
import com.baidu.jprotobuf.pbrpc.DummyLogIDGenerator;
import com.baidu.jprotobuf.pbrpc.LogIDGenerator;
import com.baidu.jprotobuf.pbrpc.ProtobufRPC;
import com.baidu.jprotobuf.pbrpc.utils.ReflectionUtils;
import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.lang.reflect.Method;

public abstract class RpcMethodInfo {
    private Method method;
    private ProtobufRPC protobufPRC;
    private String serviceName;
    private String methodName;
    private long onceTalkTimeout;
    private Class<? extends Object> inputClass;
    private Class<? extends Object> outputClass;
    private LogIDGenerator logIDGenerator;
    private ClientAttachmentHandler clientAttachmentHandler;
    private AuthenticationDataHandler authenticationDataHandler;

    public abstract byte[] inputEncode(Object var1) throws IOException;

    public abstract Object outputDecode(byte[] var1) throws IOException;

    public static boolean isMessageType(Method method) {
        Class<?> returnType;
        boolean paramMessagetType = false;
        Class<?>[] types = method.getParameterTypes();
        if (types.length == 1 && GeneratedMessage.class.isAssignableFrom(types[0])) {
            paramMessagetType = true;
        }
        if (!ReflectionUtils.isVoid(returnType = method.getReturnType()) && GeneratedMessage.class.isAssignableFrom(returnType)) {
            if (paramMessagetType) {
                return true;
            }
            throw new IllegalArgumentException("Invalid RPC method. parameter type and return type should define in same way.");
        }
        return false;
    }

    public RpcMethodInfo(Method method, ProtobufRPC protobufPRC) {
        Class authenticationDataHandlerCls;
        Class attachmentHandlerClass;
        Class logIDGeneratorClass;
        Class<?> returnType;
        this.method = method;
        this.protobufPRC = protobufPRC;
        Class<?>[] types = method.getParameterTypes();
        if (types.length > 1) {
            throw new IllegalArgumentException("RPC method can not has more than one parameter. illegal method:" + method.getName());
        }
        if (types.length == 1) {
            this.inputClass = types[0];
        }
        if (!ReflectionUtils.isVoid(returnType = method.getReturnType())) {
            this.outputClass = returnType;
        }
        if ((logIDGeneratorClass = protobufPRC.logIDGenerator()) != DummyLogIDGenerator.class) {
            try {
                this.logIDGenerator = (LogIDGenerator)logIDGeneratorClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalAccessError("Can not initialize 'logIDGenerator' of class '" + logIDGeneratorClass.getName() + "'");
            }
        }
        if ((attachmentHandlerClass = protobufPRC.attachmentHandler()) != DummyClientAttachmentHandler.class) {
            try {
                this.clientAttachmentHandler = (ClientAttachmentHandler)attachmentHandlerClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalAccessError("Can not initialize 'ClientAttachmentHandler' of class '" + attachmentHandlerClass.getName() + "'");
            }
        }
        if ((authenticationDataHandlerCls = protobufPRC.authenticationDataHandler()) != DummyAuthenticationDataHandler.class) {
            try {
                this.authenticationDataHandler = (AuthenticationDataHandler)authenticationDataHandlerCls.newInstance();
            }
            catch (Exception e) {
                throw new IllegalAccessError("Can not initialize 'AuthenticationDataHandler' of class '" + authenticationDataHandlerCls.getName() + "'");
            }
        }
    }

    public LogIDGenerator getLogIDGenerator() {
        return this.logIDGenerator;
    }

    public ClientAttachmentHandler getClientAttachmentHandler() {
        return this.clientAttachmentHandler;
    }

    public Class<? extends Object> getInputClass() {
        return this.inputClass;
    }

    public Class<? extends Object> getOutputClass() {
        return this.outputClass;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public long getOnceTalkTimeout() {
        return this.onceTalkTimeout;
    }

    public void setOnceTalkTimeout(long onceTalkTimeout) {
        this.onceTalkTimeout = onceTalkTimeout;
    }

    public Method getMethod() {
        return this.method;
    }

    public ProtobufRPC getProtobufPRC() {
        return this.protobufPRC;
    }

    public AuthenticationDataHandler getAuthenticationDataHandler() {
        return this.authenticationDataHandler;
    }
}

