/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.registry;

import com.baidu.jprotobuf.pbrpc.registry.RegisterInfo;
import com.baidu.jprotobuf.pbrpc.registry.RegistryCenterService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;

public abstract class AsyncRegistryService
implements RegistryCenterService {
    private LinkedBlockingDeque<RegisterInfo> asyncQueue = new LinkedBlockingDeque(100);
    private boolean stop;
    private ExecutorService es = Executors.newFixedThreadPool(1);

    public boolean isStop() {
        return this.stop;
    }

    public void stop() {
        this.stop = true;
        this.es.shutdown();
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public AsyncRegistryService() {
        this.es.execute(new Runnable(){

            @Override
            public void run() {
                while (!AsyncRegistryService.this.stop) {
                    RegisterInfo registerInfo = null;
                    try {
                        registerInfo = (RegisterInfo)AsyncRegistryService.this.asyncQueue.take();
                        AsyncRegistryService.this.doRegister(registerInfo);
                    }
                    catch (Exception e) {
                        if (registerInfo == null) continue;
                        AsyncRegistryService.this.asyncQueue.addLast(registerInfo);
                    }
                }
            }
        });
    }

    @Override
    public final void register(RegisterInfo url) {
        this.asyncQueue.add(url);
    }

    protected abstract void doRegister(RegisterInfo var1);
}

