/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.server;

import com.baidu.bjf.remoting.protobuf.Codec;
import com.baidu.bjf.remoting.protobuf.ProtobufProxy;
import com.baidu.jprotobuf.pbrpc.ProtobufRPCService;
import com.baidu.jprotobuf.pbrpc.intercept.MethodInvocationInfo;
import com.baidu.jprotobuf.pbrpc.management.ServerStatus;
import com.baidu.jprotobuf.pbrpc.server.AbstractAnnotationRpcHandler;
import com.baidu.jprotobuf.pbrpc.server.RpcData;
import com.baidu.jprotobuf.pbrpc.utils.ServiceSignatureUtils;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class AnnotationRpcHandler
extends AbstractAnnotationRpcHandler {
    private static final Logger PERFORMANCE_LOGGER = Logger.getLogger("performance-log");
    private Codec inputCodec;
    private Codec outputCodec;
    private String serviceSignature;

    public AnnotationRpcHandler(Method method, Object service, ProtobufRPCService protobufPRCService) {
        super(method, service, protobufPRCService);
        if (this.getInputClass() != null) {
            this.inputCodec = ProtobufProxy.create((Class)this.getInputClass());
        }
        if (this.getOutputClass() != null) {
            this.outputCodec = ProtobufProxy.create((Class)this.getOutputClass());
        }
        this.serviceSignature = ServiceSignatureUtils.makeSignature(this.getServiceName(), this.getMethodName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RpcData doRealHandle(RpcData data) throws Exception {
        Object[] param;
        Object input = null;
        Object ret = null;
        if (this.inputCodec != null) {
            if (data.getData() != null) {
                input = this.inputCodec.decode(data.getData());
            }
            param = new Object[]{input};
        } else {
            param = new Object[]{};
        }
        if (this.getAuthenticationHandler() != null) {
            this.getAuthenticationHandler().handle(data.getAuthenticationData(), this.getServiceName(), this.getMethodName(), param);
        }
        RpcData retData = new RpcData();
        if (this.getAttachmentHandler() != null) {
            byte[] responseAttachment = this.getAttachmentHandler().handleAttachement(data.getAttachment(), this.getServiceName(), this.getMethodName(), param);
            retData.setAttachment(responseAttachment);
        }
        long time = System.currentTimeMillis();
        try {
            if (this.getInterceptor() != null) {
                MethodInvocationInfo methodInvocationInfo = new MethodInvocationInfo(this.getService(), param, this.getMethod(), data.getExtraParams());
                this.getInterceptor().beforeInvoke(methodInvocationInfo);
                ret = this.getInterceptor().process(methodInvocationInfo);
                if (ret != null) {
                    PERFORMANCE_LOGGER.fine("RPC client invoke method(by intercepter) '" + this.getMethod().getName() + "' time took:" + (System.currentTimeMillis() - time) + " ms");
                    if (this.outputCodec != null) {
                        byte[] response = this.outputCodec.encode(ret);
                        retData.setData(response);
                    }
                    RpcData rpcData = retData;
                    return rpcData;
                }
            }
            ret = this.getMethod().invoke(this.getService(), param);
            long took = System.currentTimeMillis() - time;
            PERFORMANCE_LOGGER.fine("RPC server invoke method(local) '" + this.getMethod().getName() + "' time took:" + took + " ms");
            ServerStatus.incr(this.serviceSignature, took);
            if (ret == null) {
                RpcData rpcData = retData;
                return rpcData;
            }
            if (this.outputCodec != null) {
                byte[] response = this.outputCodec.encode(ret);
                retData.setData(response);
            }
            RpcData rpcData = retData;
            return rpcData;
        }
        finally {
            if (this.getInterceptor() != null) {
                this.getInterceptor().afterProcess();
            }
        }
    }
}

