/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport;

import com.baidu.jprotobuf.pbrpc.transport.Connection;
import com.baidu.jprotobuf.pbrpc.transport.RpcChannelFutureListener;
import com.baidu.jprotobuf.pbrpc.transport.RpcClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class ChannelPoolObjectFactory
extends BasePooledObjectFactory<Connection> {
    private static final Logger LOGGER = Logger.getLogger(ChannelPoolObjectFactory.class.getName());
    private final RpcClient rpcClient;
    private final String host;
    private final int port;

    public ChannelPoolObjectFactory(RpcClient rpcClient, String host, int port) {
        this.rpcClient = rpcClient;
        this.host = host;
        this.port = port;
    }

    public Connection create() throws Exception {
        return this.fetchConnection();
    }

    public PooledObject<Connection> wrap(Connection connection) {
        InetSocketAddress address = this.host == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.host, this.port);
        ChannelFuture future = this.rpcClient.connect(address);
        future.awaitUninterruptibly();
        if (!future.isSuccess()) {
            LOGGER.log(Level.SEVERE, "failed to get result from stp", future.cause());
        } else {
            connection.setIsConnected(true);
        }
        future.addListener((GenericFutureListener)new RpcChannelFutureListener(connection));
        connection.setFuture(future);
        return new DefaultPooledObject((Object)connection);
    }

    public Connection fetchConnection() {
        return new Connection(this.rpcClient);
    }

    public void destroyObject(PooledObject<Connection> p) throws Exception {
        Connection c = (Connection)p.getObject();
        Channel channel = c.getFuture().channel();
        if (channel.isOpen() && channel.isActive()) {
            channel.close();
        }
    }

    public boolean validateObject(PooledObject<Connection> p) {
        Connection c = (Connection)p.getObject();
        Channel channel = c.getFuture().channel();
        return channel.isOpen() && channel.isActive();
    }

    public void activateObject(PooledObject<Connection> p) throws Exception {
    }

    public void passivateObject(PooledObject<Connection> p) throws Exception {
        ((Connection)p.getObject()).clearRequests();
    }
}

