/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport;

import com.baidu.jprotobuf.pbrpc.transport.RpcClient;
import com.baidu.jprotobuf.pbrpc.transport.RpcClientCallState;
import io.netty.channel.ChannelFuture;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class Connection {
    private static final int MAX_REQUEST_SIZE = 102400;
    private ChannelFuture future;
    private AtomicBoolean isConnected = new AtomicBoolean();
    private BlockingQueue<RpcClientCallState> requestQueue;
    private RpcClient client;

    public Connection(RpcClient client) {
        this.isConnected.set(false);
        this.future = null;
        this.requestQueue = new ArrayBlockingQueue<RpcClientCallState>(102400);
        this.client = client;
    }

    public ChannelFuture getFuture() {
        return this.future;
    }

    public void setFuture(ChannelFuture future) {
        this.future = future;
    }

    public boolean isConnected() {
        return this.isConnected.get();
    }

    public void setIsConnected(boolean isConnected) {
        this.isConnected.set(isConnected);
    }

    public boolean produceRequest(RpcClientCallState state) {
        return this.requestQueue.add(state);
    }

    public RpcClientCallState consumeRequest() {
        return (RpcClientCallState)this.requestQueue.poll();
    }

    public void clearRequests() {
        this.requestQueue.clear();
    }

    public RpcClient getRpcClient() {
        return this.client;
    }
}

