/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport;

import com.baidu.jprotobuf.pbrpc.data.RpcDataPackage;
import com.baidu.jprotobuf.pbrpc.transport.ChannelPool;
import com.baidu.jprotobuf.pbrpc.transport.Connection;
import com.baidu.jprotobuf.pbrpc.transport.RpcClient;
import com.baidu.jprotobuf.pbrpc.transport.RpcClientCallState;
import com.baidu.jprotobuf.pbrpc.transport.RpcTimerTask;
import com.google.protobuf.RpcCallback;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcChannel {
    private static Logger LOG = Logger.getLogger(RpcChannel.class.getName());
    private RpcClient rpcClient;
    private ChannelPool channelPool;

    public void testChannlConnect() {
        Connection channel = this.channelPool.getChannel();
        this.channelPool.returnChannel(channel);
    }

    public RpcChannel(RpcClient rpcClient, String host, int port) {
        this.rpcClient = rpcClient;
        this.channelPool = new ChannelPool(rpcClient, host, port);
        rpcClient.setChannelPool(this.channelPool);
    }

    public Connection getConnection() {
        Connection channel = this.channelPool.getChannel();
        return channel;
    }

    public void releaseConnection(Connection connection) {
        this.channelPool.returnChannel(connection);
    }

    public void doTransport(Connection connection, RpcDataPackage rpcDataPackage, RpcCallback<RpcDataPackage> callback, long onceTalkTimeout) {
        if (rpcDataPackage == null) {
            throw new IllegalArgumentException("param 'rpcDataPackage' is null.");
        }
        long callMethodStart = System.currentTimeMillis();
        Timeout timeout = this.rpcClient.getTimer().newTimeout((TimerTask)new RpcTimerTask(rpcDataPackage.getRpcMeta().getCorrelationId(), this.rpcClient, onceTalkTimeout, TimeUnit.MILLISECONDS), onceTalkTimeout, TimeUnit.MILLISECONDS);
        RpcClientCallState state = new RpcClientCallState(callback, rpcDataPackage, timeout);
        Long correlationId = state.getDataPackage().getRpcMeta().getCorrelationId();
        this.rpcClient.registerPendingRequest(correlationId, state);
        if (!connection.getFuture().isSuccess()) {
            try {
                connection.produceRequest(state);
            }
            catch (IllegalStateException e) {
                RpcClientCallState callState = this.rpcClient.removePendingRequest(correlationId);
                if (callState != null) {
                    callState.handleFailure(e.getMessage());
                    LOG.log(Level.FINE, "id:" + correlationId + " is put in the queue");
                }
            }
        } else {
            connection.getFuture().channel().writeAndFlush((Object)state.getDataPackage());
        }
        long callMethodEnd = System.currentTimeMillis();
        LOG.log(Level.FINE, "profiling callMethod cost " + (callMethodEnd - callMethodStart) + "ms");
    }

    public void close() {
        if (this.channelPool != null) {
            this.channelPool.stop();
        }
    }
}

