/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport;

import com.baidu.jprotobuf.pbrpc.data.RpcDataPackage;
import com.google.protobuf.RpcCallback;
import io.netty.util.Timeout;
import java.util.concurrent.TimeUnit;

public class RpcClientCallState {
    private RpcCallback<RpcDataPackage> callback;
    private long startTimestamp;
    private RpcDataPackage dataPackage;
    private Timeout timeout;

    public RpcClientCallState(RpcCallback<RpcDataPackage> callback, RpcDataPackage dataPackage, Timeout timeout) {
        this.callback = callback;
        this.dataPackage = dataPackage;
        this.timeout = timeout;
        this.startTimestamp = System.currentTimeMillis();
    }

    public RpcCallback<RpcDataPackage> getCallback() {
        return this.callback;
    }

    public void setCallback(RpcCallback<RpcDataPackage> callback) {
        this.callback = callback;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public RpcDataPackage getDataPackage() {
        return this.dataPackage;
    }

    public void setDataPackage(RpcDataPackage dataPackage) {
        this.dataPackage = dataPackage;
    }

    public Timeout getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Timeout timeout) {
        this.timeout = timeout;
    }

    public void handleTimeout(long timeout, TimeUnit timeUnit) {
        this.dataPackage.errorCode(62);
        this.dataPackage.errorText("method request time out, please check 'onceTalkTimeout' property. current value is:" + timeout + "(" + (Object)((Object)timeUnit) + ")");
        this.callback(this.dataPackage);
    }

    private void callback(RpcDataPackage message) {
        if (null != this.callback) {
            this.callback.run((Object)message);
        }
    }

    public void handleFailure(int erroCode, String message) {
        this.dataPackage.errorCode(erroCode);
        this.dataPackage.errorText(message);
        this.timeout.cancel();
        this.callback(this.dataPackage);
    }

    public void handleFailure(String message) {
        this.handleFailure(2001, message);
    }

    public void handleResponse(RpcDataPackage response) {
        this.timeout.cancel();
        this.callback(response);
    }
}

