/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport;

import com.baidu.jprotobuf.pbrpc.transport.RpcClient;
import com.baidu.jprotobuf.pbrpc.transport.handler.RpcClientServiceHandler;
import com.baidu.jprotobuf.pbrpc.transport.handler.RpcDataPackageCompressHandler;
import com.baidu.jprotobuf.pbrpc.transport.handler.RpcDataPackageDecoder;
import com.baidu.jprotobuf.pbrpc.transport.handler.RpcDataPackageEncoder;
import com.baidu.jprotobuf.pbrpc.transport.handler.RpcDataPackageUnCompressHandler;
import com.baidu.jprotobuf.pbrpc.transport.handler.RpcServerChannelIdleHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcClientPipelineinitializer
extends ChannelInitializer<Channel> {
    private static Logger LOG = Logger.getLogger(RpcClientPipelineinitializer.class.getName());
    private static final String CLIENT_ENCODER = "client_data_encoder";
    private static final String CLIENT_DECODER = "client_data_decoder";
    private static final String RPC_CHANNEL_STATE_AWARE_HANDLER = "RpcChannelStateAwareHandler";
    private static final String RPC_CHANNEL_IDLE_HANDLER = "idel_channal_handler";
    private static final String CLIENT_HANDLER = "client_handler";
    private static final String COMPRESS = "compress_handler";
    private static final String UNCOMPRESS = "uncompress";
    private RpcClient rpcClient;

    public RpcClientPipelineinitializer(RpcClient client) {
        this.rpcClient = client;
    }

    protected void initChannel(Channel ch) throws Exception {
        LOG.log(Level.FINEST, "begin process RPC server response to client handler");
        ChannelPipeline channelPipe = ch.pipeline();
        int idleTimeout = this.rpcClient.getRpcClientOptions().getIdleTimeout();
        channelPipe.addFirst(RPC_CHANNEL_STATE_AWARE_HANDLER, (ChannelHandler)new IdleStateHandler(idleTimeout, idleTimeout, idleTimeout));
        channelPipe.addFirst(RPC_CHANNEL_IDLE_HANDLER, (ChannelHandler)new RpcServerChannelIdleHandler());
        channelPipe.addFirst(COMPRESS, (ChannelHandler)new RpcDataPackageCompressHandler());
        channelPipe.addFirst(CLIENT_ENCODER, (ChannelHandler)new RpcDataPackageEncoder(this.rpcClient.getRpcClientOptions().getChunkSize()));
        int messageLengthFieldStart = 4;
        int messageLengthFieldWidth = 4;
        int adjustSize = 4;
        channelPipe.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.rpcClient.getRpcClientOptions().getMaxSize(), messageLengthFieldStart, messageLengthFieldWidth, adjustSize, 0));
        channelPipe.addLast(CLIENT_DECODER, (ChannelHandler)new RpcDataPackageDecoder(-1));
        channelPipe.addLast(UNCOMPRESS, (ChannelHandler)new RpcDataPackageUnCompressHandler());
        channelPipe.addLast(CLIENT_HANDLER, (ChannelHandler)new RpcClientServiceHandler(this.rpcClient));
    }
}

