/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport;

import com.baidu.jprotobuf.pbrpc.ServerAttachmentHandler;
import com.baidu.jprotobuf.pbrpc.intercept.InvokerInterceptor;
import com.baidu.jprotobuf.pbrpc.management.HttpServer;
import com.baidu.jprotobuf.pbrpc.server.IDLServiceExporter;
import com.baidu.jprotobuf.pbrpc.server.RpcServiceRegistry;
import com.baidu.jprotobuf.pbrpc.transport.RpcServerOptions;
import com.baidu.jprotobuf.pbrpc.transport.RpcServerPipelineInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcServer
extends ServerBootstrap {
    private static final int DEFAULT_WAIT_STOP_INTERVAL = 200;
    private static final Logger LOG = Logger.getLogger(RpcServer.class.getName());
    private AtomicBoolean stop = new AtomicBoolean(false);
    private RpcServerOptions rpcServerOptions;
    private RpcServerPipelineInitializer rpcServerPipelineInitializer;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel channel;
    private InetSocketAddress inetSocketAddress;
    private long startTime;
    private HttpServer httpServer;
    private BlockingQueue<Runnable> blockingqueue = new LinkedBlockingQueue<Runnable>();
    private ThreadPoolExecutor es;
    private RpcServiceRegistry rpcServiceRegistry;

    public void setInterceptor(InvokerInterceptor interceptor) {
        if (this.rpcServiceRegistry != null) {
            this.rpcServiceRegistry.setInterceptor(interceptor);
        }
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.inetSocketAddress;
    }

    public ThreadPoolExecutor getEs() {
        return this.es;
    }

    public RpcServer(Class<? extends ServerChannel> serverChannelClass, RpcServerOptions serverOptions, RpcServiceRegistry rpcServiceRegistry) {
        if (rpcServiceRegistry == null) {
            throw new RuntimeException("protperty 'rpcServiceRegistry ' is null.");
        }
        if (serverOptions == null) {
            serverOptions = new RpcServerOptions();
        }
        if (serverOptions.getIoEventGroupType() == 0) {
            this.bossGroup = new NioEventLoopGroup(serverOptions.getAcceptorThreads());
            this.workerGroup = new NioEventLoopGroup(serverOptions.getWorkThreads());
        } else {
            this.bossGroup = new EpollEventLoopGroup(serverOptions.getAcceptorThreads());
            this.workerGroup = new EpollEventLoopGroup(serverOptions.getWorkThreads());
        }
        if (serverOptions.getTaskTheads() > 0) {
            this.es = new ThreadPoolExecutor(serverOptions.getTaskTheads(), serverOptions.getTaskTheads(), 60L, TimeUnit.SECONDS, this.blockingqueue);
        }
        this.group(this.bossGroup, this.workerGroup);
        this.channel(serverChannelClass);
        this.option(ChannelOption.SO_BACKLOG, serverOptions.getBacklog());
        this.childOption(ChannelOption.SO_KEEPALIVE, serverOptions.isKeepAlive());
        this.childOption(ChannelOption.SO_REUSEADDR, true);
        this.childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        this.childOption(ChannelOption.TCP_NODELAY, serverOptions.isTcpNoDelay());
        this.childOption(ChannelOption.SO_LINGER, serverOptions.getSoLinger());
        this.childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, serverOptions.getConnectTimeout());
        this.childOption(ChannelOption.SO_RCVBUF, serverOptions.getReceiveBufferSize());
        this.childOption(ChannelOption.SO_SNDBUF, serverOptions.getSendBufferSize());
        this.rpcServiceRegistry = rpcServiceRegistry;
        rpcServiceRegistry.doRegisterMetaService();
        this.rpcServerOptions = serverOptions;
        this.rpcServerPipelineInitializer = new RpcServerPipelineInitializer(rpcServiceRegistry, this.rpcServerOptions, this.es);
        this.childHandler((ChannelHandler)this.rpcServerPipelineInitializer);
    }

    public RpcServer(RpcServerOptions serverOptions) {
        this(NioServerSocketChannel.class, serverOptions, new RpcServiceRegistry());
    }

    public RpcServer(RpcServerOptions serverOptions, RpcServiceRegistry rpcServiceRegistry) {
        this(NioServerSocketChannel.class, serverOptions, rpcServiceRegistry);
    }

    public RpcServer() {
        this(new RpcServerOptions());
    }

    public RpcServer(Class<? extends ServerChannel> serverChannelClass) {
        this(serverChannelClass, new RpcServerOptions(), new RpcServiceRegistry());
    }

    public void registerService(IDLServiceExporter service) {
        this.rpcServiceRegistry.registerService(service);
    }

    public void registerService(Object target) {
        this.rpcServiceRegistry.registerService(target);
    }

    public void registerDynamicService(String methodSignature, Method method, Object service, Class<? extends ServerAttachmentHandler> cls) {
        this.rpcServiceRegistry.doDynamicRegisterService(methodSignature, method, service, cls);
    }

    public void unRegisterDynamicService(String methodSignature) {
        this.rpcServiceRegistry.unRegisterDynamicService(methodSignature);
    }

    public void registerDynamicService(String serviceName, String methodName, Method method, Object service, Class<? extends ServerAttachmentHandler> cls) {
        this.rpcServiceRegistry.doDynamicRegisterService(serviceName, methodName, method, service, cls);
    }

    public void start(int port) {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(port);
        this.start(inetSocketAddress);
    }

    public void startSync(int port) {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(port);
        this.startSync(inetSocketAddress);
    }

    public void startSync(InetSocketAddress sa) {
        LOG.log(Level.INFO, "RPC starting at: " + sa);
        try {
            this.bind(sa).sync();
        }
        catch (Throwable e) {
            this.shutdown();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void start(final InetSocketAddress sa) {
        LOG.log(Level.INFO, "RPC starting at: " + sa);
        this.bind(sa).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    RpcServer.this.shutdown();
                    throw new Exception("bind port failed:" + sa.toString() + " message:" + future.toString());
                }
                RpcServer.this.channel = future.channel();
                RpcServer.this.initAfterBindPort(sa);
            }
        });
    }

    protected void initAfterBindPort(InetSocketAddress sa) {
        this.inetSocketAddress = sa;
        this.startTime = System.currentTimeMillis();
        if (this.rpcServerOptions.getHttpServerPort() > 0) {
            this.httpServer = new HttpServer(this);
            this.httpServer.start(this.rpcServerOptions.getHttpServerPort());
        }
    }

    public void waitForStop() throws InterruptedException {
        while (!this.stop.get()) {
            Thread.sleep(200L);
        }
        this.shutdown();
    }

    public void stop() {
        this.stop.set(true);
    }

    public AtomicBoolean getStop() {
        return this.stop;
    }

    public boolean isStop() {
        return this.stop.get();
    }

    public void shutdown() {
        this.stop();
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        if (this.es != null) {
            this.es.shutdown();
        }
        if (this.rpcServerPipelineInitializer != null) {
            this.rpcServerPipelineInitializer.close();
        }
        if (this.httpServer != null) {
            this.httpServer.shutdownNow();
        }
    }

    public void setStop(AtomicBoolean stop) {
        this.stop = stop;
    }

    public RpcServerOptions getRpcServerOptions() {
        return this.rpcServerOptions;
    }

    public void setRpcServerOptions(RpcServerOptions rpcServerOptions) {
        this.rpcServerOptions = rpcServerOptions;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

