/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport.handler;

import com.baidu.jprotobuf.pbrpc.data.RpcDataPackage;
import com.baidu.jprotobuf.pbrpc.data.RpcResponseMeta;
import com.baidu.jprotobuf.pbrpc.transport.RpcClient;
import com.baidu.jprotobuf.pbrpc.transport.RpcClientCallState;
import com.baidu.jprotobuf.pbrpc.transport.handler.ErrorCodes;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcClientServiceHandler
extends SimpleChannelInboundHandler<RpcDataPackage> {
    private static final Logger LOG = Logger.getLogger(RpcClientServiceHandler.class.getName());
    private RpcClient rpcClient;

    public RpcClientServiceHandler(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void channelRead0(ChannelHandlerContext ctx, RpcDataPackage dataPackage) throws Exception {
        Long correlationId = dataPackage.getRpcMeta().getCorrelationId();
        RpcClientCallState state = this.rpcClient.removePendingRequest(correlationId);
        Integer errorCode = 0;
        RpcResponseMeta response = dataPackage.getRpcMeta().getResponse();
        if (response != null) {
            errorCode = response.getErrorCode();
        }
        if (!ErrorCodes.isSuccess(errorCode)) {
            if (state == null) {
                ctx.fireChannelReadComplete();
                throw new Exception(response.getErrorText());
            }
            state.handleFailure(errorCode, response.getErrorText());
        } else if (state != null) {
            state.setDataPackage(dataPackage);
            state.handleResponse(state.getDataPackage());
        }
        ctx.fireChannelReadComplete();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.log(Level.SEVERE, cause.getCause().getMessage(), cause.getCause());
        ctx.close();
    }
}

