/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.utils;

import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public abstract class Pool<T> {
    private final GenericObjectPool<T> internalPool;

    public Pool(GenericObjectPoolConfig poolConfig, PooledObjectFactory<T> factory) {
        this.internalPool = new GenericObjectPool(factory, poolConfig);
    }

    public T getResource() {
        try {
            return (T)this.internalPool.borrowObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get a resource from the pool", e);
        }
    }

    public void returnResource(T resource) {
        try {
            this.internalPool.returnObject(resource);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not return the resource to the pool", e);
        }
    }

    public void returnBrokenResource(T resource) {
        try {
            this.internalPool.invalidateObject(resource);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not return the resource to the pool", e);
        }
    }

    public void destroy() {
        try {
            this.internalPool.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not destroy the pool", e);
        }
    }
}

