/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.client;

import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import com.baidu.jprotobuf.pbrpc.AuthenticationDataHandler;
import com.baidu.jprotobuf.pbrpc.ClientAttachmentHandler;
import com.baidu.jprotobuf.pbrpc.CompressType;
import com.baidu.jprotobuf.pbrpc.DummyAuthenticationDataHandler;
import com.baidu.jprotobuf.pbrpc.DummyLogIDGenerator;
import com.baidu.jprotobuf.pbrpc.ErrorDataException;
import com.baidu.jprotobuf.pbrpc.LogIDGenerator;
import com.baidu.jprotobuf.pbrpc.ProtobufRPC;
import com.baidu.jprotobuf.pbrpc.client.GeneratedMessageRpcMethodInfo;
import com.baidu.jprotobuf.pbrpc.client.PojoRpcMethodInfo;
import com.baidu.jprotobuf.pbrpc.client.RpcMethodInfo;
import com.baidu.jprotobuf.pbrpc.data.RpcDataPackage;
import com.baidu.jprotobuf.pbrpc.data.RpcResponseMeta;
import com.baidu.jprotobuf.pbrpc.transport.BlockingRpcCallback;
import com.baidu.jprotobuf.pbrpc.transport.Connection;
import com.baidu.jprotobuf.pbrpc.transport.ExceptionHandler;
import com.baidu.jprotobuf.pbrpc.transport.RpcChannel;
import com.baidu.jprotobuf.pbrpc.transport.RpcClient;
import com.baidu.jprotobuf.pbrpc.transport.RpcErrorMessage;
import com.baidu.jprotobuf.pbrpc.transport.handler.ErrorCodes;
import com.baidu.jprotobuf.pbrpc.utils.ServiceSignatureUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DynamicProtobufRpcProxy {
    private static final Logger LOGGER = Logger.getLogger(DynamicProtobufRpcProxy.class.getName());
    private RpcClient rpcClient;
    private String host;
    private int port;
    private static final Object NULL = new Object();
    private Map<String, RpcChannel> rpcChannelMap = new HashMap<String, RpcChannel>();
    private Map<String, RpcMethodInfo> rpcMethods = new HashMap<String, RpcMethodInfo>();
    private static final Map<String, String> EMPTY_CONFIG = Collections.emptyMap();
    public static final String TIMEOUT_KEY = "TIME_OUT";
    private ExceptionHandler exceptionHandler;

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public DynamicProtobufRpcProxy(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
        if (rpcClient == null) {
            throw new IllegalArgumentException("Param 'rpcClient'  is null.");
        }
    }

    public Object invoke(String serviceSignature, Object proxy, Method method, Object[] args, Class<? extends ClientAttachmentHandler> cls) throws Throwable {
        return this.invoke(serviceSignature, proxy, method, args, EMPTY_CONFIG, cls);
    }

    private long getTimeout(Map<String, String> config) {
        return this.getLong(config, TIMEOUT_KEY);
    }

    private long getLong(Map<String, String> config, String key) {
        if (config == null) {
            return 0L;
        }
        String value = config.get(key);
        return StringUtils.toLong((String)value, (long)0L);
    }

    public Object invoke(String serviceSignature, Object proxy, Method method, Object[] args, Map<String, String> config, Class<? extends ClientAttachmentHandler> cls) throws Throwable {
        return this.invoke("__DYANMICE_SERVICE__", serviceSignature, proxy, method, args, config, cls);
    }

    public Object invoke(String serviceName, String methodName, Object proxy, Method method, Object[] args, Map<String, String> config, Class<? extends ClientAttachmentHandler> cls) throws Throwable {
        return this.invoke(serviceName, methodName, proxy, method, args, config, cls, DummyAuthenticationDataHandler.class, DummyLogIDGenerator.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(final String serviceName, final String methodName, Object proxy, Method method, Object[] args, final Map<String, String> config, final Class<? extends ClientAttachmentHandler> cls, final Class<? extends AuthenticationDataHandler> authenticationDataHandlerCls, final Class<? extends LogIDGenerator> logIdGenerateorCls) throws Throwable {
        RpcChannel rpcChannel;
        String serviceSignature = ServiceSignatureUtils.makeSignature(serviceName, methodName);
        Object result = this.processEqualsHashCodeToStringMethod(serviceSignature, method, args);
        if (result != NULL) {
            return result;
        }
        RpcMethodInfo rpcMethodInfo = this.rpcMethods.get(serviceSignature);
        if (rpcMethodInfo == null) {
            String string = serviceSignature;
            synchronized (string) {
                ProtobufRPC protobufPRC = new ProtobufRPC(){

                    public Class<? extends Annotation> annotationType() {
                        return ProtobufRPC.class;
                    }

                    public String serviceName() {
                        return serviceName;
                    }

                    public long onceTalkTimeout() {
                        return DynamicProtobufRpcProxy.this.getTimeout(config);
                    }

                    public String methodName() {
                        return methodName;
                    }

                    public Class<? extends LogIDGenerator> logIDGenerator() {
                        return logIdGenerateorCls;
                    }

                    public CompressType compressType() {
                        return CompressType.NO;
                    }

                    public Class<? extends ClientAttachmentHandler> attachmentHandler() {
                        return cls;
                    }

                    public Class<? extends AuthenticationDataHandler> authenticationDataHandler() {
                        return authenticationDataHandlerCls;
                    }
                };
                RpcMethodInfo methodInfo = !RpcMethodInfo.isMessageType(method) ? new PojoRpcMethodInfo(method, protobufPRC) : new GeneratedMessageRpcMethodInfo(method, protobufPRC);
                methodInfo.setOnceTalkTimeout(protobufPRC.onceTalkTimeout());
                methodInfo.setServiceName(protobufPRC.serviceName());
                methodInfo.setMethodName(protobufPRC.methodName());
                rpcMethodInfo = methodInfo;
                this.rpcMethods.put(serviceSignature, methodInfo);
            }
        }
        if ((rpcChannel = this.rpcChannelMap.get(serviceSignature)) == null) {
            String string = serviceSignature;
            synchronized (string) {
                rpcChannel = new RpcChannel(this.rpcClient, this.host, this.port);
                this.rpcChannelMap.put(serviceSignature, rpcChannel);
            }
        }
        return this.doInvoke(serviceSignature, rpcChannel, proxy, rpcMethodInfo, method, args);
    }

    protected Object doInvoke(String serviceSignature, final RpcChannel rpcChannel, Object proxy, final RpcMethodInfo rpcMethodInfo, final Method method, final Object[] args) throws Throwable {
        if (rpcMethodInfo == null) {
            throw new IllegalAccessError("Can not invoke method '" + method.getName() + "' due to not a protbufRpc method.");
        }
        long onceTalkTimeout = rpcMethodInfo.getOnceTalkTimeout();
        if (onceTalkTimeout <= 0L) {
            onceTalkTimeout = this.rpcClient.getRpcClientOptions().getOnceTalkTimeout();
        }
        RpcDataPackage rpcDataPackage = this.buildRequestDataPackage(rpcMethodInfo, args);
        rpcDataPackage.getRpcMeta().setCorrelationId(this.rpcClient.getNextCorrelationId());
        if (rpcChannel == null) {
            throw new RuntimeException("No rpcChannel bind with serviceSignature '" + serviceSignature + "'");
        }
        final Connection connection = rpcChannel.getConnection();
        final BlockingRpcCallback callback = new BlockingRpcCallback(new BlockingRpcCallback.CallbackDone(){

            @Override
            public void done() {
                if (rpcChannel != null) {
                    rpcChannel.releaseConnection(connection);
                }
            }
        });
        rpcChannel.doTransport(connection, rpcDataPackage, callback, onceTalkTimeout);
        final String m = rpcMethodInfo.getMethodName();
        if (method.getReturnType().isAssignableFrom(Future.class)) {
            Future<Object> f = new Future<Object>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return callback.isDone();
                }

                @Override
                public Object get() throws InterruptedException, ExecutionException {
                    try {
                        Object o = DynamicProtobufRpcProxy.this.doWaitCallback(method, args, rpcMethodInfo.getServiceName(), m, rpcMethodInfo, callback, -1L, null);
                        return o;
                    }
                    catch (Exception e) {
                        throw new ExecutionException(e.getMessage(), e);
                    }
                }

                @Override
                public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    try {
                        Object o = DynamicProtobufRpcProxy.this.doWaitCallback(method, args, rpcMethodInfo.getServiceName(), m, rpcMethodInfo, callback, timeout, unit);
                        return o;
                    }
                    catch (Exception e) {
                        throw new ExecutionException(e.getMessage(), e);
                    }
                }
            };
            return f;
        }
        Object o = this.doWaitCallback(method, args, rpcMethodInfo.getServiceName(), rpcMethodInfo.getMethodName(), rpcMethodInfo, callback, -1L, null);
        return o;
    }

    protected RpcDataPackage buildRequestDataPackage(RpcMethodInfo rpcMethodInfo, Object[] args) throws IOException {
        RpcDataPackage rpcDataPackage = RpcDataPackage.buildRpcDataPackage(rpcMethodInfo, args);
        return rpcDataPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doWaitCallback(Method method, Object[] args, String serviceName, String methodName, RpcMethodInfo rpcMethodInfo, BlockingRpcCallback callback, long timeout, TimeUnit unit) throws Exception {
        byte[] data;
        ClientAttachmentHandler attachmentHandler;
        byte[] attachment;
        Integer errorCode;
        RpcDataPackage message;
        RpcResponseMeta response;
        if (!callback.isDone()) {
            long timeExpire = 0L;
            if (timeout > 0L && unit != null) {
                timeExpire = System.currentTimeMillis() + unit.toMillis(timeout);
            }
            while (!callback.isDone()) {
                BlockingRpcCallback blockingRpcCallback = callback;
                synchronized (blockingRpcCallback) {
                    try {
                        if (timeExpire > 0L && System.currentTimeMillis() > timeExpire) {
                            throw new TimeoutException("Ocurrs time out with specfied time " + timeout + " " + (Object)((Object)unit));
                        }
                        callback.wait(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        if ((response = (message = callback.getMessage()).getRpcMeta().getResponse()) != null && !ErrorCodes.isSuccess(errorCode = response.getErrorCode())) {
            if (this.exceptionHandler != null) {
                RpcErrorMessage rpcErrorMessage = new RpcErrorMessage(errorCode, response.getErrorText());
                Exception exception = this.exceptionHandler.handleException(rpcErrorMessage);
                if (exception != null) {
                    throw exception;
                }
            } else {
                String error = message.getRpcMeta().getResponse().getErrorText();
                throw new ErrorDataException("A error occurred: errorCode=" + errorCode + " errorMessage:" + error, (int)errorCode);
            }
        }
        if ((attachment = message.getAttachment()) != null && (attachmentHandler = rpcMethodInfo.getClientAttachmentHandler()) != null) {
            attachmentHandler.handleResponse(attachment, serviceName, methodName, args);
        }
        if ((data = message.getData()) == null) {
            return null;
        }
        Object o = rpcMethodInfo.outputDecode(data);
        return o;
    }

    private Object processEqualsHashCodeToStringMethod(String serviceSignature, Method method, Object[] args) {
        String name = method.getName();
        Object[] parameters = args;
        if (parameters == null) {
            parameters = new Object[]{};
        }
        if ("toString".equals(name) && parameters.length == 0) {
            return serviceSignature;
        }
        if ("hashCode".equals(name) && parameters.length == 0) {
            return serviceSignature.hashCode();
        }
        if ("equals".equals(name) && parameters.length == 1) {
            return this.equals(parameters[0]);
        }
        return NULL;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void close() {
        Collection<RpcChannel> rpcChannels = this.rpcChannelMap.values();
        for (RpcChannel rpcChann : rpcChannels) {
            try {
                rpcChann.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e.getCause());
            }
        }
    }
}

