/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.client;

import com.baidu.jprotobuf.pbrpc.ProtobufRPC;
import com.baidu.jprotobuf.pbrpc.client.RpcMethodInfo;
import com.google.protobuf.GeneratedMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;

public class GeneratedMessageRpcMethodInfo
extends RpcMethodInfo {
    private static final String PROTOBUF_PARSE_METHOD = "parseFrom";
    private Method parseFromMethod;

    public GeneratedMessageRpcMethodInfo(Method method, ProtobufRPC protobufPRC) {
        super(method, protobufPRC);
        Class<? extends Object> outputClass = this.getOutputClass();
        if (outputClass != null && GeneratedMessage.class.isAssignableFrom(outputClass)) {
            try {
                this.parseFromMethod = outputClass.getMethod(PROTOBUF_PARSE_METHOD, InputStream.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Override
    public byte[] inputEncode(Object input) throws IOException {
        if (input instanceof GeneratedMessage) {
            return ((GeneratedMessage)input).toByteArray();
        }
        return null;
    }

    @Override
    public Object outputDecode(byte[] output) throws IOException {
        Class<? extends Object> outputClass = this.getOutputClass();
        if (this.parseFromMethod != null && output != null) {
            try {
                return this.parseFromMethod.invoke(outputClass, new ByteArrayInputStream(output));
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return null;
    }
}

