/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.client;

import com.baidu.jprotobuf.pbrpc.ClientAttachmentHandler;
import com.baidu.jprotobuf.pbrpc.ErrorDataException;
import com.baidu.jprotobuf.pbrpc.ProtobufRPC;
import com.baidu.jprotobuf.pbrpc.client.GeneratedMessageRpcMethodInfo;
import com.baidu.jprotobuf.pbrpc.client.PojoRpcMethodInfo;
import com.baidu.jprotobuf.pbrpc.client.ProxyFactory;
import com.baidu.jprotobuf.pbrpc.client.RpcMethodInfo;
import com.baidu.jprotobuf.pbrpc.client.ServiceLocatorCallback;
import com.baidu.jprotobuf.pbrpc.client.ServiceUrlAccessible;
import com.baidu.jprotobuf.pbrpc.data.RpcDataPackage;
import com.baidu.jprotobuf.pbrpc.data.RpcResponseMeta;
import com.baidu.jprotobuf.pbrpc.intercept.InvokerInterceptor;
import com.baidu.jprotobuf.pbrpc.intercept.MethodInvocationInfo;
import com.baidu.jprotobuf.pbrpc.transport.BlockingRpcCallback;
import com.baidu.jprotobuf.pbrpc.transport.Connection;
import com.baidu.jprotobuf.pbrpc.transport.ExceptionHandler;
import com.baidu.jprotobuf.pbrpc.transport.RpcChannel;
import com.baidu.jprotobuf.pbrpc.transport.RpcClient;
import com.baidu.jprotobuf.pbrpc.transport.RpcErrorMessage;
import com.baidu.jprotobuf.pbrpc.transport.handler.ErrorCodes;
import com.baidu.jprotobuf.pbrpc.utils.ServiceSignatureUtils;
import com.baidu.jprotobuf.pbrpc.utils.StringUtils;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProtobufRpcProxy<T>
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getLogger(ProtobufRpcProxy.class.getName());
    private static final Object NULL = new Object();
    private static final Logger PERFORMANCE_LOGGER = Logger.getLogger("performance-log");
    private static final String SHARE_KEY = "___share_key";
    private Map<String, RpcMethodInfo> cachedRpcMethods = new HashMap<String, RpcMethodInfo>();
    private final RpcClient rpcClient;
    private Map<String, RpcChannel> rpcChannelMap = new HashMap<String, RpcChannel>();
    private String host;
    private int port;
    private boolean lookupStubOnStartup = true;
    private T instance;
    private ServiceLocatorCallback serviceLocatorCallback;
    private String serviceUrl;
    private InvokerInterceptor interceptor;
    private ExceptionHandler exceptionHandler;
    private final Class<T> interfaceClass;

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setInterceptor(InvokerInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void setServiceLocatorCallback(ServiceLocatorCallback serviceLocatorCallback) {
        this.serviceLocatorCallback = serviceLocatorCallback;
    }

    public boolean isLookupStubOnStartup() {
        return this.lookupStubOnStartup;
    }

    public void setLookupStubOnStartup(boolean lookupStubOnStartup) {
        this.lookupStubOnStartup = lookupStubOnStartup;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Set<String> getServiceSignatures() {
        Method[] methods;
        if (!this.cachedRpcMethods.isEmpty()) {
            return new HashSet<String>(this.cachedRpcMethods.keySet());
        }
        HashSet<String> serviceSignatures = new HashSet<String>();
        for (Method method : methods = this.interfaceClass.getMethods()) {
            ProtobufRPC protobufPRC = method.getAnnotation(ProtobufRPC.class);
            if (protobufPRC == null) continue;
            String serviceName = protobufPRC.serviceName();
            String methodName = protobufPRC.methodName();
            if (StringUtils.isEmpty(methodName)) {
                methodName = method.getName();
            }
            String methodSignature = ServiceSignatureUtils.makeSignature(serviceName, methodName);
            serviceSignatures.add(methodSignature);
        }
        if (serviceSignatures.isEmpty()) {
            throw new IllegalArgumentException("This no protobufRpc method in interface class:" + this.interfaceClass.getName());
        }
        return serviceSignatures;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public ProtobufRpcProxy(RpcClient rpcClient, Class<T> interfaceClass) {
        this.interfaceClass = interfaceClass;
        if (rpcClient == null) {
            throw new IllegalArgumentException("Param 'rpcClient'  is null.");
        }
        if (interfaceClass == null) {
            throw new IllegalArgumentException("Param 'interfaceClass'  is null.");
        }
        this.rpcClient = rpcClient;
    }

    protected Method[] getMethds() {
        return this.interfaceClass.getMethods();
    }

    public synchronized T proxy() {
        Method[] methods;
        if (this.instance != null) {
            return this.instance;
        }
        for (Method method : methods = this.getMethds()) {
            String methodSignature;
            ProtobufRPC protobufPRC = this.getProtobufRPCAnnotation(method);
            if (protobufPRC == null) continue;
            String serviceName = protobufPRC.serviceName();
            String methodName = protobufPRC.methodName();
            if (StringUtils.isEmpty(methodName)) {
                methodName = method.getName();
            }
            if (this.cachedRpcMethods.containsKey(methodSignature = ServiceSignatureUtils.makeSignature(serviceName, methodName))) {
                throw new IllegalArgumentException("Method with annotation ProtobufPRC already defined service name [" + serviceName + "] method name [" + methodName + "]");
            }
            RpcMethodInfo methodInfo = !RpcMethodInfo.isMessageType(method) ? new PojoRpcMethodInfo(method, protobufPRC) : new GeneratedMessageRpcMethodInfo(method, protobufPRC);
            methodInfo.setOnceTalkTimeout(protobufPRC.onceTalkTimeout());
            methodInfo.setServiceName(serviceName);
            methodInfo.setMethodName(methodName);
            this.cachedRpcMethods.put(methodSignature, methodInfo);
            String eHost = this.host;
            int ePort = this.port;
            if (this.serviceLocatorCallback != null) {
                InetSocketAddress address = this.serviceLocatorCallback.fetchAddress(methodSignature);
                if (address == null) {
                    throw new RuntimeException("fetch a null address from serviceLocatorCallback by serviceSignature '" + methodSignature + "'");
                }
                eHost = address.getHostName();
                ePort = address.getPort();
            }
            String channelKey = methodSignature;
            if (this.rpcClient.getRpcClientOptions().isShareThreadPoolUnderEachProxy()) {
                channelKey = SHARE_KEY;
            }
            if (!this.rpcChannelMap.containsKey(channelKey)) {
                RpcChannel rpcChannel = new RpcChannel(this.rpcClient, eHost, ePort);
                if (this.lookupStubOnStartup) {
                    rpcChannel.testChannlConnect();
                }
                this.rpcChannelMap.put(channelKey, rpcChannel);
            }
            this.serviceUrl = eHost + ":" + ePort;
        }
        if (this.cachedRpcMethods.isEmpty()) {
            throw new IllegalArgumentException("This no protobufRpc method in interface class:" + this.interfaceClass.getName());
        }
        Class[] clazz = new Class[]{this.interfaceClass, ServiceUrlAccessible.class};
        this.instance = ProxyFactory.createProxy(clazz, this.interfaceClass.getClassLoader(), this);
        return this.instance;
    }

    protected RpcDataPackage buildRequestDataPackage(RpcMethodInfo rpcMethodInfo, Object[] args) throws IOException {
        RpcDataPackage rpcDataPackage = RpcDataPackage.buildRpcDataPackage(rpcMethodInfo, args);
        return rpcDataPackage;
    }

    public void close() {
        Collection<RpcChannel> rpcChannels = this.rpcChannelMap.values();
        for (RpcChannel rpcChann : rpcChannels) {
            try {
                rpcChann.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e.getCause());
            }
        }
    }

    private Object processEqualsHashCodeToStringMethod(Method method, Object[] args) {
        String name = method.getName();
        Object[] parameters = args;
        if (parameters == null) {
            parameters = new Object[]{};
        }
        if ("toString".equals(name) && parameters.length == 0) {
            return this.serviceUrl;
        }
        if ("hashCode".equals(name) && parameters.length == 0) {
            return this.serviceUrl.hashCode();
        }
        if ("equals".equals(name) && parameters.length == 1) {
            return this.equals(parameters[0]);
        }
        return NULL;
    }

    protected ProtobufRPC getProtobufRPCAnnotation(Method method) {
        ProtobufRPC protobufPRC = method.getAnnotation(ProtobufRPC.class);
        return protobufPRC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        String methodSignature;
        RpcMethodInfo rpcMethodInfo;
        String mName = method.getName();
        if ("getServiceUrl".equals(mName)) {
            return this.serviceUrl;
        }
        Object result = this.processEqualsHashCodeToStringMethod(method, args);
        if (result != NULL) {
            return result;
        }
        final long time = System.currentTimeMillis();
        ProtobufRPC protobufPRC = this.getProtobufRPCAnnotation(method);
        if (protobufPRC == null) {
            throw new IllegalAccessError("Target method is not marked annotation @ProtobufPRC. method name :" + method.getDeclaringClass().getName() + "." + method.getName());
        }
        final String serviceName = protobufPRC.serviceName();
        String methodName = protobufPRC.methodName();
        if (StringUtils.isEmpty(methodName)) {
            methodName = mName;
        }
        if ((rpcMethodInfo = this.cachedRpcMethods.get(methodSignature = ServiceSignatureUtils.makeSignature(serviceName, methodName))) == null) {
            throw new IllegalAccessError("Can not invoke method '" + method.getName() + "' due to not a protbufRpc method.");
        }
        long onceTalkTimeout = rpcMethodInfo.getOnceTalkTimeout();
        if (onceTalkTimeout <= 0L) {
            onceTalkTimeout = this.rpcClient.getRpcClientOptions().getOnceTalkTimeout();
        }
        RpcDataPackage rpcDataPackage = this.buildRequestDataPackage(rpcMethodInfo, args);
        rpcDataPackage.getRpcMeta().setCorrelationId(this.rpcClient.getNextCorrelationId());
        String channelKey = methodSignature;
        if (this.rpcClient.getRpcClientOptions().isShareThreadPoolUnderEachProxy()) {
            channelKey = SHARE_KEY;
        }
        try {
            RpcChannel rpcChannel;
            if (this.interceptor != null) {
                byte[] extraParams = rpcDataPackage.getRpcMeta().getRequest().getExtraParam();
                MethodInvocationInfo methodInvocationInfo = new MethodInvocationInfo(proxy, args, method, extraParams);
                this.interceptor.beforeInvoke(methodInvocationInfo);
                Object ret = this.interceptor.process(methodInvocationInfo);
                if (ret != null) {
                    PERFORMANCE_LOGGER.fine("RPC client invoke method(by intercepter) '" + method.getName() + "' time took:" + (System.currentTimeMillis() - time) + " ms");
                    Object object = ret;
                    return object;
                }
                rpcDataPackage.extraParams(methodInvocationInfo.getExtraParams());
            }
            if ((rpcChannel = this.rpcChannelMap.get(channelKey)) == null) {
                throw new RuntimeException("No rpcChannel bind with serviceSignature '" + channelKey + "'");
            }
            final Connection connection = rpcChannel.getConnection();
            BlockingRpcCallback.CallbackDone callbackDone = null;
            if (!this.rpcClient.getRpcClientOptions().isInnerResuePool()) {
                callbackDone = new BlockingRpcCallback.CallbackDone(){

                    @Override
                    public void done() {
                        if (rpcChannel != null) {
                            rpcChannel.releaseConnection(connection);
                        }
                    }
                };
            }
            final BlockingRpcCallback callback = new BlockingRpcCallback(callbackDone);
            try {
                rpcChannel.doTransport(connection, rpcDataPackage, callback, onceTalkTimeout);
            }
            finally {
                if (this.rpcClient.getRpcClientOptions().isInnerResuePool() && rpcChannel != null) {
                    rpcChannel.releaseConnection(connection);
                }
            }
            final String m = methodName;
            if (method.getReturnType().isAssignableFrom(Future.class)) {
                Future<Object> f;
                Future<Object> future = f = new Future<Object>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return false;
                    }

                    @Override
                    public boolean isCancelled() {
                        return false;
                    }

                    @Override
                    public boolean isDone() {
                        return callback.isDone();
                    }

                    @Override
                    public Object get() throws InterruptedException, ExecutionException {
                        try {
                            Object o = ProtobufRpcProxy.this.doWaitCallback(method, args, serviceName, m, rpcMethodInfo, callback, -1L, null);
                            PERFORMANCE_LOGGER.fine("RPC client invoke method '" + method.getName() + "' time took:" + (System.currentTimeMillis() - time) + " ms");
                            return o;
                        }
                        catch (Exception e) {
                            throw new ExecutionException(e.getMessage(), e);
                        }
                    }

                    @Override
                    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        try {
                            return ProtobufRpcProxy.this.doWaitCallback(method, args, serviceName, m, rpcMethodInfo, callback, timeout, unit);
                        }
                        catch (Exception e) {
                            throw new ExecutionException(e.getMessage(), e);
                        }
                    }
                };
                return future;
            }
            Object o = this.doWaitCallback(method, args, serviceName, methodName, rpcMethodInfo, callback, -1L, null);
            PERFORMANCE_LOGGER.fine("RPC client invoke method '" + method.getName() + "' time took:" + (System.currentTimeMillis() - time) + " ms");
            Object object = o;
            return object;
        }
        finally {
            if (this.interceptor != null) {
                this.interceptor.afterProcess();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doWaitCallback(Method method, Object[] args, String serviceName, String methodName, RpcMethodInfo rpcMethodInfo, BlockingRpcCallback callback, long timeout, TimeUnit unit) throws Exception {
        byte[] data;
        ClientAttachmentHandler attachmentHandler;
        byte[] attachment;
        Integer errorCode;
        RpcDataPackage message;
        RpcResponseMeta response;
        if (!callback.isDone()) {
            long timeExpire = 0L;
            if (timeout > 0L && unit != null) {
                timeExpire = System.currentTimeMillis() + unit.toMillis(timeout);
            }
            while (!callback.isDone()) {
                BlockingRpcCallback blockingRpcCallback = callback;
                synchronized (blockingRpcCallback) {
                    try {
                        if (timeExpire > 0L && System.currentTimeMillis() > timeExpire) {
                            throw new TimeoutException("Ocurrs time out with specfied time " + timeout + " " + (Object)((Object)unit));
                        }
                        callback.wait(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        if ((response = (message = callback.getMessage()).getRpcMeta().getResponse()) != null && !ErrorCodes.isSuccess(errorCode = response.getErrorCode())) {
            if (this.exceptionHandler != null) {
                RpcErrorMessage rpcErrorMessage = new RpcErrorMessage(errorCode, response.getErrorText());
                Exception exception = this.exceptionHandler.handleException(rpcErrorMessage);
                if (exception != null) {
                    throw exception;
                }
            } else {
                String error = message.getRpcMeta().getResponse().getErrorText();
                throw new ErrorDataException("A error occurred: errorCode=" + errorCode + " errorMessage:" + error, (int)errorCode);
            }
        }
        if ((attachment = message.getAttachment()) != null && (attachmentHandler = rpcMethodInfo.getClientAttachmentHandler()) != null) {
            attachmentHandler.handleResponse(attachment, serviceName, methodName, args);
        }
        if ((data = message.getData()) == null) {
            return null;
        }
        Object o = rpcMethodInfo.outputDecode(data);
        return o;
    }
}

