/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.data;

import com.baidu.jprotobuf.pbrpc.AuthenticationDataHandler;
import com.baidu.jprotobuf.pbrpc.ClientAttachmentHandler;
import com.baidu.jprotobuf.pbrpc.LogIDGenerator;
import com.baidu.jprotobuf.pbrpc.client.RpcMethodInfo;
import com.baidu.jprotobuf.pbrpc.data.ChunkInfo;
import com.baidu.jprotobuf.pbrpc.data.Readable;
import com.baidu.jprotobuf.pbrpc.data.RpcHeadMeta;
import com.baidu.jprotobuf.pbrpc.data.RpcMeta;
import com.baidu.jprotobuf.pbrpc.data.RpcRequestMeta;
import com.baidu.jprotobuf.pbrpc.data.RpcResponseMeta;
import com.baidu.jprotobuf.pbrpc.data.Writerable;
import com.baidu.jprotobuf.pbrpc.utils.ArrayUtils;
import com.baidu.jprotobuf.pbrpc.utils.LogIdThreadLocalHolder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;

public class RpcDataPackage
implements Readable,
Writerable {
    private static Logger LOG = Logger.getLogger(RpcDataPackage.class.getName());
    private RpcHeadMeta head;
    private RpcMeta rpcMeta;
    private byte[] data;
    private byte[] attachment;
    private long timeStamp;

    public void mergeData(byte[] data) {
        if (data == null) {
            return;
        }
        if (this.data == null) {
            this.data = data;
            return;
        }
        int len = this.data.length + data.length;
        byte[] newData = new byte[len];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        System.arraycopy(data, 0, newData, this.data.length, data.length);
        this.data = newData;
    }

    public boolean isChunkPackage() {
        return this.getChunkStreamId() != null;
    }

    public boolean isFinalPackage() {
        if (this.rpcMeta == null) {
            return true;
        }
        ChunkInfo chunkInfo = this.rpcMeta.getChunkInfo();
        if (chunkInfo == null) {
            return true;
        }
        return chunkInfo.getChunkId() == -1L;
    }

    public Long getChunkStreamId() {
        if (this.rpcMeta == null) {
            return null;
        }
        ChunkInfo chunkInfo = this.rpcMeta.getChunkInfo();
        if (chunkInfo == null) {
            return null;
        }
        return chunkInfo.getStreamId();
    }

    public List<RpcDataPackage> chunk(long chunkSize) {
        if (chunkSize < 1L || this.data == null || chunkSize > (long)this.data.length) {
            return Arrays.asList(this);
        }
        long streamId = UUID.randomUUID().toString().hashCode();
        int chunkId = 0;
        int startPos = 0;
        int cSize = Long.valueOf(chunkSize).intValue();
        ArrayList<RpcDataPackage> ret = new ArrayList<RpcDataPackage>();
        while (startPos < this.data.length) {
            byte[] subarray = ArrayUtils.subarray(this.data, startPos, startPos + cSize);
            RpcDataPackage clone = this.copy();
            clone.data(subarray);
            if (startPos > 0) {
                clone.attachment(null);
            }
            if ((startPos += cSize) >= this.data.length) {
                chunkId = -1;
            }
            clone.chunkInfo(streamId, chunkId);
            ret.add(clone);
            ++chunkId;
        }
        return ret;
    }

    public RpcDataPackage copy() {
        RpcDataPackage rpcDataPackage = new RpcDataPackage();
        if (this.head != null) {
            rpcDataPackage.setHead(this.head.copy());
        }
        if (this.rpcMeta != null) {
            rpcDataPackage.setRpcMeta(this.rpcMeta.copy());
        }
        rpcDataPackage.setData(this.data);
        rpcDataPackage.setAttachment(this.attachment);
        return rpcDataPackage;
    }

    public RpcDataPackage magicCode(String magicCode) {
        this.setMagicCode(magicCode);
        return this;
    }

    public RpcDataPackage serviceName(String serviceName) {
        RpcRequestMeta request = this.initRequest();
        request.setServiceName(serviceName);
        return this;
    }

    public String serviceName() {
        RpcRequestMeta request = this.initRequest();
        return request.getSerivceName();
    }

    public String methodName() {
        RpcRequestMeta request = this.initRequest();
        return request.getMethodName();
    }

    public RpcDataPackage methodName(String methodName) {
        RpcRequestMeta request = this.initRequest();
        request.setMethodName(methodName);
        return this;
    }

    public RpcDataPackage data(byte[] data) {
        this.setData(data);
        return this;
    }

    public RpcDataPackage attachment(byte[] attachment) {
        this.setAttachment(attachment);
        return this;
    }

    public RpcDataPackage authenticationData(byte[] authenticationData) {
        RpcMeta rpcMeta = this.initRpcMeta();
        rpcMeta.setAuthenticationData(authenticationData);
        return this;
    }

    public RpcDataPackage correlationId(long correlationId) {
        RpcMeta rpcMeta = this.initRpcMeta();
        rpcMeta.setCorrelationId(correlationId);
        return this;
    }

    public RpcDataPackage compressType(int compressType) {
        RpcMeta rpcMeta = this.initRpcMeta();
        rpcMeta.setCompressType(compressType);
        return this;
    }

    public RpcDataPackage logId(long logId) {
        RpcRequestMeta request = this.initRequest();
        request.setLogId(logId);
        return this;
    }

    public RpcDataPackage errorCode(int errorCode) {
        RpcResponseMeta response = this.initResponse();
        response.setErrorCode(errorCode);
        return this;
    }

    public RpcDataPackage errorText(String errorText) {
        RpcResponseMeta response = this.initResponse();
        response.setErrorText(errorText);
        return this;
    }

    public RpcDataPackage extraParams(byte[] params) {
        RpcRequestMeta request = this.initRequest();
        request.setExtraParam(params);
        return this;
    }

    public RpcDataPackage chunkInfo(long streamId, int chunkId) {
        ChunkInfo chunkInfo = new ChunkInfo();
        chunkInfo.setStreamId(streamId);
        chunkInfo.setChunkId(chunkId);
        RpcMeta rpcMeta = this.initRpcMeta();
        rpcMeta.setChunkInfo(chunkInfo);
        return this;
    }

    private RpcRequestMeta initRequest() {
        RpcMeta rpcMeta = this.initRpcMeta();
        RpcRequestMeta request = rpcMeta.getRequest();
        if (request == null) {
            request = new RpcRequestMeta();
            rpcMeta.setRequest(request);
        }
        return request;
    }

    private RpcResponseMeta initResponse() {
        RpcMeta rpcMeta = this.initRpcMeta();
        RpcResponseMeta response = rpcMeta.getResponse();
        if (response == null) {
            response = new RpcResponseMeta();
            rpcMeta.setResponse(response);
        }
        return response;
    }

    private RpcMeta initRpcMeta() {
        if (this.rpcMeta == null) {
            this.rpcMeta = new RpcMeta();
        }
        return this.rpcMeta;
    }

    public void setMagicCode(String magicCode) {
        if (this.head == null) {
            this.head = new RpcHeadMeta();
        }
        this.head.setMagicCode(magicCode);
    }

    public RpcHeadMeta getHead() {
        return this.head;
    }

    public void setHead(RpcHeadMeta head) {
        this.head = head;
    }

    public RpcMeta getRpcMeta() {
        return this.rpcMeta;
    }

    protected void setRpcMeta(RpcMeta rpcMeta) {
        this.rpcMeta = rpcMeta;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public byte[] getAttachment() {
        return this.attachment;
    }

    public void setAttachment(byte[] attachment) {
        this.attachment = attachment;
    }

    public RpcDataPackage getErrorResponseRpcDataPackage(int errorCode, String errorText) {
        return this.getErrorResponseRpcDataPackage(new RpcResponseMeta(errorCode, errorText));
    }

    public RpcDataPackage getErrorResponseRpcDataPackage(RpcResponseMeta responseMeta) {
        RpcDataPackage response = new RpcDataPackage();
        RpcMeta eRpcMeta = this.rpcMeta;
        if (eRpcMeta == null) {
            eRpcMeta = new RpcMeta();
        }
        eRpcMeta.setResponse(responseMeta);
        eRpcMeta.setRequest(null);
        response.setRpcMeta(eRpcMeta);
        response.setHead(this.head);
        return response;
    }

    @Override
    public byte[] write() {
        if (this.head == null) {
            throw new RuntimeException("property 'head' is null.");
        }
        if (this.rpcMeta == null) {
            throw new RuntimeException("property 'rpcMeta' is null.");
        }
        int totolSize = 0;
        int dataSize = 0;
        if (this.data != null) {
            dataSize = this.data.length;
            totolSize += dataSize;
        }
        int attachmentSize = 0;
        if (this.attachment != null) {
            attachmentSize = this.attachment.length;
            totolSize += attachmentSize;
        }
        this.rpcMeta.setAttachmentSize(attachmentSize);
        byte[] rpcMetaBytes = this.rpcMeta.write();
        int rpcMetaSize = rpcMetaBytes.length;
        this.head.setMetaSize(rpcMetaSize);
        this.head.setMessageSize(totolSize += rpcMetaSize);
        totolSize += 12;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(totolSize);
            baos.write(this.head.write());
            baos.write(rpcMetaBytes);
            if (this.data != null) {
                baos.write(this.data);
            }
            if (this.attachment != null) {
                baos.write(this.attachment);
            }
            byte[] ret = baos.toByteArray();
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void read(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("param 'bytes' is null.");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        byte[] headBytes = new byte[12];
        bais.read(headBytes, 0, 12);
        this.head = new RpcHeadMeta();
        this.head.read(headBytes);
        int metaSize = this.head.getMetaSize();
        byte[] metaBytes = new byte[metaSize];
        bais.read(metaBytes, 0, metaSize);
        this.rpcMeta = new RpcMeta();
        this.rpcMeta.read(metaBytes);
        int attachmentSize = this.rpcMeta.getAttachmentSize();
        int totalSize = this.head.getMessageSize();
        int dataSize = totalSize - metaSize - attachmentSize;
        if (dataSize > 0) {
            this.data = new byte[dataSize];
            bais.read(this.data, 0, dataSize);
        }
        if (attachmentSize > 0) {
            this.attachment = new byte[attachmentSize];
            bais.read(this.attachment, 0, attachmentSize);
        }
    }

    public static RpcDataPackage buildRpcDataPackage(RpcMethodInfo methodInfo, Object[] args) throws IOException {
        byte[] authenticationData;
        AuthenticationDataHandler authenticationDataHandler;
        byte[] attachment;
        Long elogId;
        byte[] data;
        RpcDataPackage dataPackage = new RpcDataPackage();
        dataPackage.magicCode("PRPC");
        dataPackage.serviceName(methodInfo.getServiceName()).methodName(methodInfo.getMethodName());
        dataPackage.compressType(methodInfo.getProtobufPRC().compressType().value());
        if (args != null && args.length == 1 && (data = methodInfo.inputEncode(args[0])) != null) {
            dataPackage.data(data);
        }
        if ((elogId = LogIdThreadLocalHolder.getLogId()) != null) {
            LOG.info("Detected LogIdThreadLocalHolder contains a logId, will always use this log id.");
            dataPackage.logId(elogId);
        } else {
            LogIDGenerator logIDGenerator = methodInfo.getLogIDGenerator();
            if (logIDGenerator != null) {
                long logId = logIDGenerator.generate(methodInfo.getServiceName(), methodInfo.getMethod().getName(), args);
                dataPackage.logId(logId);
            }
        }
        ClientAttachmentHandler attachmentHandler = methodInfo.getClientAttachmentHandler();
        if (attachmentHandler != null && (attachment = attachmentHandler.handleRequest(methodInfo.getServiceName(), methodInfo.getMethod().getName(), args)) != null) {
            dataPackage.attachment(attachment);
        }
        if ((authenticationDataHandler = methodInfo.getAuthenticationDataHandler()) != null && (authenticationData = authenticationDataHandler.create(methodInfo.getServiceName(), methodInfo.getMethod().getName(), args)) != null) {
            dataPackage.authenticationData(authenticationData);
        }
        return dataPackage;
    }
}

