/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.management;

import com.baidu.jprotobuf.pbrpc.management.ServerStatus;
import com.baidu.jprotobuf.pbrpc.transport.RpcServer;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.HashMap;
import java.util.Map;

@ChannelHandler.Sharable
public class HttpServerInboundHandler
extends ChannelInboundHandlerAdapter {
    private static final String DEFAULT_URI = "/";
    private static final String STATUS_URI = "/status";
    private HttpRequest request;
    private Map<String, Object> responseMapping = new HashMap<String, Object>();
    private ServerStatus serverStatus;

    public HttpServerInboundHandler(RpcServer rpcServer) {
        this.serverStatus = new ServerStatus(rpcServer);
        ServerStatus.Enabled();
        this.responseMapping.put(STATUS_URI, this.serverStatus);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            Object responser;
            this.request = (HttpRequest)msg;
            String uri = this.request.getUri();
            if (DEFAULT_URI.equals(uri)) {
                uri = STATUS_URI;
            }
            if ((responser = this.responseMapping.get(uri)) != null) {
                this.writeResponse(ctx, responser.toString());
            } else {
                this.writeResponse(ctx, "No such path '" + uri + "'");
            }
        }
    }

    private void writeResponse(ChannelHandlerContext ctx, String content) throws Exception {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])content.getBytes("UTF-8")));
        response.headers().set("Content-Type", (Object)"text/html");
        response.headers().set("Content-Length", (Object)response.content().readableBytes());
        if (HttpHeaders.isKeepAlive((HttpMessage)this.request)) {
            response.headers().set("Connection", (Object)"keep-alive");
        }
        ctx.write((Object)response);
        ctx.flush();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close();
    }

    public void close() {
        if (this.serverStatus != null) {
            this.serverStatus.close();
        }
    }
}

