/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.management;

import com.baidu.jprotobuf.pbrpc.meta.MetaExportHelper;
import com.baidu.jprotobuf.pbrpc.meta.RpcServiceMeta;
import com.baidu.jprotobuf.pbrpc.meta.RpcServiceMetaList;
import com.baidu.jprotobuf.pbrpc.transport.RpcServer;
import com.baidu.jprotobuf.pbrpc.transport.RpcServerOptions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStatus {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerStatus.class);
    private static final int SECONDS_IN_HOUR = 3600;
    private static final int SECONDS_IN_DAY = 86400;
    private int port;
    private int httpPort;
    private long startTime;
    private RpcServer rpcServer;
    private transient boolean close = false;
    private static transient boolean enabled = false;
    public static final ConcurrentHashMap<String, AtomicLong> REQUEST_COUNTS = new ConcurrentHashMap();
    public static final BlockingQueue<RequestInfo> ASYNC_REQUEST = new LinkedBlockingQueue<RequestInfo>();
    private static ExecutorService es;

    public static void Enabled() {
        enabled = true;
    }

    public static void incr(String serviceSignature, long timetook) {
        if (!enabled) {
            return;
        }
        ASYNC_REQUEST.add(new RequestInfo(timetook, serviceSignature));
    }

    private static void doIncr(RequestInfo requestInfo) {
        AtomicLong newOne = new AtomicLong();
        AtomicLong oldOne = REQUEST_COUNTS.putIfAbsent(requestInfo.signature, newOne);
        if (oldOne != null) {
            newOne = oldOne;
        }
        newOne.incrementAndGet();
    }

    public ServerStatus(RpcServer rpcServer) {
        this.rpcServer = rpcServer;
        this.startTime = rpcServer.getStartTime();
        this.port = rpcServer.getInetSocketAddress().getPort();
        this.httpPort = rpcServer.getRpcServerOptions().getHttpServerPort();
        es = Executors.newSingleThreadExecutor();
        es.execute(new Runnable(){

            @Override
            public void run() {
                while (!ServerStatus.this.close) {
                    try {
                        RequestInfo requestInfo = ASYNC_REQUEST.poll(1L, TimeUnit.SECONDS);
                        if (requestInfo == null) continue;
                        ServerStatus.doIncr(requestInfo);
                    }
                    catch (InterruptedException e) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head>");
        ret.append("Server online: ").append(this.getOnlineDuration(this.startTime)).append("<br>");
        ret.append("RPC port:").append(this.port).append("<br>");
        ret.append("Http management port:").append(this.httpPort).append("<br>");
        ret.append("Chunk enabled").append("<br>");
        ret.append("Compress enabled(Gzip Snappy)").append("<br>");
        ret.append("Attachment enabled").append("<br>");
        if (this.rpcServer.getEs() != null) {
            ret.append("--------------Thread status----------------").append("<br>");
            ret.append("Max task count:").append(this.rpcServer.getEs().getMaximumPoolSize()).append("<br>");
            ret.append("Running task count:").append(this.rpcServer.getEs().getActiveCount()).append("<br>");
            ret.append("Waiting task count:").append(this.rpcServer.getEs().getQueue().size()).append("<br>");
            ret.append("<br>").append("<br>");
        }
        ret.append("<pre>");
        ret.append("--------------properties info(").append(RpcServerOptions.class.getDeclaredFields().length).append(")----------------").append("<br>");
        ret.append(this.rpcServer.getRpcServerOptions());
        ret.append("<br>").append("<br>");
        RpcServiceMetaList exportRPCMeta = MetaExportHelper.exportRPCMeta(this.port);
        List<RpcServiceMeta> metaList = exportRPCMeta.getRpcServiceMetas();
        if (metaList != null) {
            ret.append("--------------RPC service list(").append(metaList.size()).append(") ----------------").append("<br>");
            for (RpcServiceMeta rpcServiceMeta : metaList) {
                ret.append("<B>").append("Service name:").append(rpcServiceMeta.getServiceName()).append("<br>");
                ret.append("Method name:").append(rpcServiceMeta.getMethodName()).append("</B>").append("<br>");
                ret.append("Request IDL:").append("<br>").append(rpcServiceMeta.getInputProto()).append("<br>");
                ret.append("Response IDL:").append("<br>").append(rpcServiceMeta.getOutputProto()).append("<br>");
                ret.append("<br>");
            }
        }
        ret.append("<br>").append("<br>");
        ret.append("--------------protobuf idl info ----------------").append("<br>");
        ret.append(exportRPCMeta.getTypesIDL());
        ret.append(exportRPCMeta.getRpcsIDL());
        ret.append("</pre>");
        ret.append("</html>");
        ret.append("--------------Request Info ----------------").append("<br>");
        HashMap<String, AtomicLong> copy = new HashMap<String, AtomicLong>(REQUEST_COUNTS);
        Iterator iterator = copy.entrySet().iterator();
        ret.append("<table><tr><td>service</td><td>request count</td></tr>");
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            ret.append("<tr>");
            ret.append("<td>").append((String)next.getKey()).append("</td>");
            ret.append("<td>").append(next.getValue()).append("</td>");
            ret.append("</tr>");
        }
        ret.append("</table>");
        return ret.toString();
    }

    private String getOnlineDuration(long startTime) {
        StringBuilder ret = new StringBuilder();
        long ms = (System.currentTimeMillis() - startTime) / 1000L;
        long days = ms / 86400L;
        long hours = ms % 86400L / 3600L;
        long seconds = ms % 86400L % 3600L;
        ret.append(days).append(" days ").append(hours).append(" hours ").append(seconds).append(" seconds");
        return ret.toString();
    }

    public void close() {
        this.close = true;
        if (es != null) {
            es.shutdown();
        }
    }

    private static class RequestInfo {
        private long took;
        private String signature;

        public RequestInfo(long took, String signature) {
            this.took = took;
            this.signature = signature;
        }
    }
}

