/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.meta;

import com.baidu.bjf.remoting.protobuf.ProtobufIDLGenerator;
import com.baidu.jprotobuf.pbrpc.ProtobufRPCService;
import com.baidu.jprotobuf.pbrpc.RpcHandler;
import com.baidu.jprotobuf.pbrpc.meta.RpcMetaAware;
import com.baidu.jprotobuf.pbrpc.meta.RpcServiceMeta;
import com.baidu.jprotobuf.pbrpc.meta.RpcServiceMetaList;
import com.baidu.jprotobuf.pbrpc.server.RpcServiceRegistry;
import com.baidu.jprotobuf.pbrpc.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class RpcServiceMetaServiceProvider {
    private static final String LINE_BREAK = "\n";
    public static final String RPC_META_SERVICENAME = "__rpc_meta_watch_service__";
    private RpcServiceRegistry rpcServiceRegistry;
    private RpcServiceMetaList rpcServiceMetaList;

    public RpcServiceMetaServiceProvider(RpcServiceRegistry rpcServiceRegistry) {
        this.rpcServiceRegistry = rpcServiceRegistry;
    }

    @ProtobufRPCService(serviceName="__rpc_meta_watch_service__")
    public RpcServiceMetaList getRpcServiceMetaInfo() {
        if (this.rpcServiceMetaList != null) {
            return this.rpcServiceMetaList;
        }
        StringBuilder typesIDL = new StringBuilder();
        StringBuilder rpcsIDL = new StringBuilder();
        HashMap<String, StringBuilder> rpcIDLMap = new HashMap<String, StringBuilder>();
        HashSet cachedTypes = new HashSet();
        HashSet cachedEnumTypes = new HashSet();
        Collection<RpcHandler> services = this.rpcServiceRegistry.getServices();
        ArrayList<RpcServiceMeta> list = new ArrayList<RpcServiceMeta>(services.size());
        for (RpcHandler rpcHandler : services) {
            String idl;
            if (!(rpcHandler instanceof RpcMetaAware)) continue;
            RpcMetaAware meta = (RpcMetaAware)((Object)rpcHandler);
            String serviceName = rpcHandler.getServiceName();
            if (RPC_META_SERVICENAME.equals(serviceName)) continue;
            RpcServiceMeta rpcServiceMeta = new RpcServiceMeta();
            rpcServiceMeta.setServiceName(serviceName);
            rpcServiceMeta.setMethodName(rpcHandler.getMethodName());
            if (rpcHandler.getInputClass() != null) {
                rpcServiceMeta.setInputObjName(rpcHandler.getInputClass().getSimpleName());
                idl = ProtobufIDLGenerator.getIDL(rpcHandler.getInputClass(), cachedTypes, cachedEnumTypes, (boolean)true);
                if (idl != null) {
                    typesIDL.append(meta.getInputMetaProto()).append(LINE_BREAK);
                }
            }
            rpcServiceMeta.setInputProto(meta.getInputMetaProto());
            if (rpcHandler.getOutputClass() != null) {
                rpcServiceMeta.setOutputObjName(rpcHandler.getOutputClass().getSimpleName());
                idl = ProtobufIDLGenerator.getIDL(rpcHandler.getOutputClass(), cachedTypes, cachedEnumTypes, (boolean)true);
                if (idl != null) {
                    typesIDL.append(meta.getOutputMetaProto()).append(LINE_BREAK);
                }
            }
            rpcServiceMeta.setOutputProto(meta.getOutputMetaProto());
            list.add(rpcServiceMeta);
            StringBuilder rpc = (StringBuilder)rpcIDLMap.get(serviceName);
            if (rpc == null) {
                rpc = new StringBuilder();
                rpcIDLMap.put(serviceName, rpc);
            }
            rpc.append("rpc ").append(rpcHandler.getMethodName()).append("(");
            if (rpcHandler.getInputClass() != null) {
                rpc.append(rpcHandler.getInputClass().getSimpleName()).append(") ");
            }
            if (rpcHandler.getOutputClass() != null) {
                rpc.append("returns (").append(rpcHandler.getOutputClass().getSimpleName()).append(");");
            }
            if (!StringUtils.isBlank(rpcHandler.getDescription())) {
                rpc.append(" //").append(rpcHandler.getDescription());
            }
            rpc.append(LINE_BREAK);
        }
        for (Map.Entry entry : rpcIDLMap.entrySet()) {
            rpcsIDL.append("service ").append((String)entry.getKey()).append(" {").append(LINE_BREAK);
            rpcsIDL.append((CharSequence)entry.getValue());
            rpcsIDL.append("}").append(LINE_BREAK);
        }
        this.rpcServiceMetaList = new RpcServiceMetaList();
        this.rpcServiceMetaList.setRpcServiceMetas(list);
        this.rpcServiceMetaList.setTypesIDL(typesIDL.toString());
        this.rpcServiceMetaList.setRpcsIDL(rpcsIDL.toString());
        return this.rpcServiceMetaList;
    }

    @ProtobufRPCService(serviceName="__rpc_meta_watch_service__")
    public void ping() {
    }
}

