/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.server;

import com.baidu.bjf.remoting.protobuf.ProtobufIDLGenerator;
import com.baidu.jprotobuf.pbrpc.DummyServerAttachmentHandler;
import com.baidu.jprotobuf.pbrpc.DummyServerAuthenticationDataHandler;
import com.baidu.jprotobuf.pbrpc.LogIDHolder;
import com.baidu.jprotobuf.pbrpc.ProtobufRPCService;
import com.baidu.jprotobuf.pbrpc.RpcHandler;
import com.baidu.jprotobuf.pbrpc.ServerAttachmentHandler;
import com.baidu.jprotobuf.pbrpc.ServerAuthenticationDataHandler;
import com.baidu.jprotobuf.pbrpc.intercept.InvokerInterceptor;
import com.baidu.jprotobuf.pbrpc.meta.RpcMetaAware;
import com.baidu.jprotobuf.pbrpc.server.RpcData;
import com.baidu.jprotobuf.pbrpc.utils.ReflectionUtils;
import com.baidu.jprotobuf.pbrpc.utils.ServiceSignatureUtils;
import com.baidu.jprotobuf.pbrpc.utils.StringUtils;
import java.lang.reflect.Method;

public abstract class AbstractAnnotationRpcHandler
implements RpcHandler,
RpcMetaAware {
    private String serviceName;
    private String methodName;
    private Method method;
    private Class inputClass;
    private Class outputClass;
    private Object service;
    private String description;
    private ServerAttachmentHandler attachmentHandler;
    protected String inputIDl;
    protected String outputIDL;
    private InvokerInterceptor interceptor;
    private ServerAuthenticationDataHandler authenticationHandler;

    public void setInterceptor(InvokerInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    protected InvokerInterceptor getInterceptor() {
        return this.interceptor;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object getService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RpcData doHandle(RpcData data) throws Exception {
        Long logId = data.getLogId();
        if (logId != null) {
            LogIDHolder.setCurrentLogid((long)logId);
        }
        try {
            RpcData rpcData = this.doRealHandle(data);
            return rpcData;
        }
        finally {
            LogIDHolder.clearLogId();
        }
    }

    protected abstract RpcData doRealHandle(RpcData var1) throws Exception;

    public AbstractAnnotationRpcHandler(Method method, Object service, ProtobufRPCService protobufPRCService) {
        Class authClass;
        Class attachmentHandlerClass;
        Class<?> returnType;
        Class<?>[] types;
        this.method = method;
        this.service = service;
        this.description = protobufPRCService.description();
        this.serviceName = protobufPRCService.serviceName();
        this.methodName = protobufPRCService.methodName();
        if (StringUtils.isEmpty(this.methodName)) {
            this.methodName = method.getName();
        }
        if ((types = method.getParameterTypes()).length > 1) {
            throw new IllegalArgumentException("RPC method can not has more than one parameter. illegal method:" + method.getName());
        }
        if (types.length == 1) {
            this.inputClass = types[0];
        }
        if (!ReflectionUtils.isVoid(returnType = method.getReturnType())) {
            this.outputClass = returnType;
        }
        if ((attachmentHandlerClass = protobufPRCService.attachmentHandler()) != DummyServerAttachmentHandler.class) {
            try {
                this.attachmentHandler = (ServerAttachmentHandler)attachmentHandlerClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalAccessError("Can not initialize 'ServerAttachmentHandler' of class '" + attachmentHandlerClass.getName() + "'");
            }
        }
        if ((authClass = protobufPRCService.authenticationDataHandler()) != DummyServerAuthenticationDataHandler.class) {
            try {
                this.authenticationHandler = (ServerAuthenticationDataHandler)authClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalAccessError("Can not initialize 'ServerAuthenticationDataHandler' of class '" + authClass.getName() + "'");
            }
        }
        if (this.inputClass != null) {
            try {
                this.inputIDl = ProtobufIDLGenerator.getIDL((Class)this.inputClass);
            }
            catch (Exception e) {
                this.inputIDl = null;
            }
        }
        if (this.outputClass != null) {
            try {
                this.outputIDL = ProtobufIDLGenerator.getIDL((Class)this.outputClass);
            }
            catch (Exception e) {
                this.outputIDL = null;
            }
        }
    }

    @Override
    public String getMethodSignature() {
        String methodSignature = ServiceSignatureUtils.makeSignature(this.serviceName, this.methodName);
        return methodSignature;
    }

    public Class getInputClass() {
        return this.inputClass;
    }

    public Class getOutputClass() {
        return this.outputClass;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    public ServerAttachmentHandler getAttachmentHandler() {
        return this.attachmentHandler;
    }

    public ServerAuthenticationDataHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    @Override
    public String getInputMetaProto() {
        return this.inputIDl;
    }

    @Override
    public String getOutputMetaProto() {
        return this.outputIDL;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

