/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.server;

import com.baidu.jprotobuf.pbrpc.ProtobufRPCService;
import com.baidu.jprotobuf.pbrpc.intercept.MethodInvocationInfo;
import com.baidu.jprotobuf.pbrpc.server.AbstractAnnotationRpcHandler;
import com.baidu.jprotobuf.pbrpc.server.RpcData;
import com.google.protobuf.GeneratedMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class MessageGeneratedRpcHandler
extends AbstractAnnotationRpcHandler {
    private static final Logger PERFORMANCE_LOGGER = Logger.getLogger("performance-log");
    private static final String PROTOBUF_PARSE_METHOD = "parseFrom";
    private Method parseFromMethod;

    public MessageGeneratedRpcHandler(Method method, Object service, ProtobufRPCService protobufPRCService) {
        super(method, service, protobufPRCService);
        if (this.getInputClass() != null && GeneratedMessage.class.isAssignableFrom(this.getInputClass())) {
            try {
                this.parseFromMethod = this.getInputClass().getMethod(PROTOBUF_PARSE_METHOD, InputStream.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RpcData doRealHandle(RpcData data) throws Exception {
        Object[] param;
        Object input = null;
        Object ret = null;
        if (data.getData() != null && this.parseFromMethod != null) {
            input = this.parseFromMethod.invoke((Object)this.getInputClass(), new ByteArrayInputStream(data.getData()));
            param = new Object[]{input};
        } else {
            param = new Object[]{};
        }
        RpcData retData = new RpcData();
        if (this.getAuthenticationHandler() != null) {
            this.getAuthenticationHandler().handle(data.getAuthenticationData(), this.getServiceName(), this.getMethodName(), param);
        }
        if (this.getAttachmentHandler() != null) {
            byte[] responseAttachment = this.getAttachmentHandler().handleAttachement(data.getAttachment(), this.getServiceName(), this.getMethodName(), param);
            retData.setAttachment(responseAttachment);
        }
        long time = System.currentTimeMillis();
        try {
            if (this.getInterceptor() != null) {
                MethodInvocationInfo methodInvocationInfo = new MethodInvocationInfo(this.getService(), param, this.getMethod(), data.getExtraParams());
                this.getInterceptor().beforeInvoke(methodInvocationInfo);
                ret = this.getInterceptor().process(methodInvocationInfo);
                if (ret != null) {
                    PERFORMANCE_LOGGER.fine("RPC client invoke method(by intercepter) '" + this.getMethod().getName() + "' time took:" + (System.currentTimeMillis() - time) + " ms");
                    if (ret instanceof GeneratedMessage) {
                        byte[] response = ((GeneratedMessage)ret).toByteArray();
                        retData.setData(response);
                    }
                    RpcData rpcData = retData;
                    return rpcData;
                }
            }
            ret = this.getMethod().invoke(this.getService(), param);
            long took = System.currentTimeMillis() - time;
            PERFORMANCE_LOGGER.fine("RPC server invoke method(local) '" + this.getMethod().getName() + "' time took:" + took + " ms");
            if (ret == null) {
                RpcData rpcData = retData;
                return rpcData;
            }
            if (ret != null && ret instanceof GeneratedMessage) {
                byte[] response = ((GeneratedMessage)ret).toByteArray();
                retData.setData(response);
            }
            RpcData rpcData = retData;
            return rpcData;
        }
        finally {
            if (this.getInterceptor() != null) {
                this.getInterceptor().afterProcess();
            }
        }
    }
}

