/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.server;

import com.baidu.jprotobuf.pbrpc.DummyServerAuthenticationDataHandler;
import com.baidu.jprotobuf.pbrpc.ProtobufRPCService;
import com.baidu.jprotobuf.pbrpc.RpcHandler;
import com.baidu.jprotobuf.pbrpc.ServerAttachmentHandler;
import com.baidu.jprotobuf.pbrpc.ServerAuthenticationDataHandler;
import com.baidu.jprotobuf.pbrpc.client.RpcMethodInfo;
import com.baidu.jprotobuf.pbrpc.intercept.InvokerInterceptor;
import com.baidu.jprotobuf.pbrpc.meta.RpcServiceMetaServiceProvider;
import com.baidu.jprotobuf.pbrpc.server.AbstractAnnotationRpcHandler;
import com.baidu.jprotobuf.pbrpc.server.AnnotationRpcHandler;
import com.baidu.jprotobuf.pbrpc.server.IDLServiceExporter;
import com.baidu.jprotobuf.pbrpc.server.IDLServiceRpcHandler;
import com.baidu.jprotobuf.pbrpc.server.MessageGeneratedRpcHandler;
import com.baidu.jprotobuf.pbrpc.utils.ReflectionUtils;
import com.baidu.jprotobuf.pbrpc.utils.ServiceSignatureUtils;
import com.baidu.jprotobuf.pbrpc.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcServiceRegistry {
    protected static final Logger LOGGER = Logger.getLogger(RpcServiceRegistry.class.getName());
    private Map<String, RpcHandler> serviceMap = new HashMap<String, RpcHandler>();
    private boolean dummyOverride = false;
    private InvokerInterceptor interceptor;

    public void setInterceptor(InvokerInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void doRegisterMetaService() {
        RpcServiceMetaServiceProvider metaService = new RpcServiceMetaServiceProvider(this);
        this.registerService(metaService);
    }

    public void unRegisterAll() {
        this.serviceMap.clear();
    }

    public void setDummyOverride(boolean dummyOverride) {
        this.dummyOverride = dummyOverride;
    }

    public void registerService(final Object target) {
        if (target == null) {
            throw new IllegalArgumentException("Param 'target' is null.");
        }
        Class<?> cls = target.getClass();
        ReflectionUtils.doWithMethods(cls, new ReflectionUtils.MethodCallback(){

            @Override
            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                ProtobufRPCService protobufPRCService = method.getAnnotation(ProtobufRPCService.class);
                if (protobufPRCService != null) {
                    RpcServiceRegistry.this.doRegiterService(method, target, protobufPRCService);
                }
            }
        });
    }

    protected RpcHandler doCreateRpcHandler(Method method, Object service, ProtobufRPCService protobufPRCService) {
        boolean messageType = RpcMethodInfo.isMessageType(method);
        AbstractAnnotationRpcHandler rpcHandler = !messageType ? new AnnotationRpcHandler(method, service, protobufPRCService) : new MessageGeneratedRpcHandler(method, service, protobufPRCService);
        rpcHandler.setInterceptor(this.interceptor);
        if (StringUtils.isEmpty(rpcHandler.getServiceName())) {
            throw new IllegalArgumentException(" serviceName from 'serviceExporter' is empty.");
        }
        return rpcHandler;
    }

    public void doDynamicRegisterService(String methodSignature, Method method, Object service, Class<? extends ServerAttachmentHandler> cls) {
        this.doDynamicRegisterService("__DYANMICE_SERVICE__", methodSignature, method, service, cls);
    }

    public void doDynamicRegisterService(String serviceName, String methodName, Method method, Object service, Class<? extends ServerAttachmentHandler> cls) {
        this.doDynamicRegisterService(serviceName, methodName, method, service, cls, DummyServerAuthenticationDataHandler.class);
    }

    public void doDynamicRegisterService(final String serviceName, final String methodName, Method method, Object service, final Class<? extends ServerAttachmentHandler> cls, final Class<? extends ServerAuthenticationDataHandler> authentiationDataCls) {
        ProtobufRPCService protobufPRCService = new ProtobufRPCService(){

            public Class<? extends Annotation> annotationType() {
                return ProtobufRPCService.class;
            }

            public String serviceName() {
                return serviceName;
            }

            public String methodName() {
                return methodName;
            }

            public String description() {
                return "";
            }

            public Class<? extends ServerAttachmentHandler> attachmentHandler() {
                return cls;
            }

            public Class<? extends ServerAuthenticationDataHandler> authenticationDataHandler() {
                return authentiationDataCls;
            }
        };
        this.doRegiterService(method, service, protobufPRCService);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doRegiterService(Method method, Object service, ProtobufRPCService protobufPRCService) {
        RpcHandler rpcHandler = this.doCreateRpcHandler(method, service, protobufPRCService);
        String methodSignature = rpcHandler.getMethodSignature();
        if (this.serviceMap.containsKey(methodSignature)) {
            if (!this.dummyOverride) throw new RuntimeException("serviceName '" + rpcHandler.getServiceName() + " ' and methodName '" + method.getName() + "' aready exist.");
            this.serviceMap.put(methodSignature, rpcHandler);
        } else {
            this.serviceMap.put(methodSignature, rpcHandler);
        }
        if (!LOGGER.isLoggable(Level.INFO)) return;
        LOGGER.info("RPC service register log: serviceName[" + rpcHandler.getServiceName() + "] methodName[" + rpcHandler.getMethodName() + "] from " + method.getDeclaringClass().getName() + "." + method.getName());
    }

    private String getMethodSignature(String serviceName, String method) {
        String methodSignature = ServiceSignatureUtils.makeSignature(serviceName, method);
        return methodSignature;
    }

    public RpcHandler lookupService(String serviceName, String methodName) {
        String methodSignature = this.getMethodSignature(serviceName, methodName);
        return this.serviceMap.get(methodSignature);
    }

    public Collection<RpcHandler> getServices() {
        return this.serviceMap.values();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerService(IDLServiceExporter serviceExporter) {
        if (serviceExporter == null) {
            throw new IllegalArgumentException("Param 'serviceExporter' is null.");
        }
        String serviceName = serviceExporter.getServiceName();
        if (StringUtils.isEmpty(serviceName)) {
            throw new IllegalArgumentException(" serviceName from 'serviceExporter' is empty.");
        }
        String methodSignature = this.getMethodSignature(serviceName, serviceExporter.getMethodName());
        if (this.serviceMap.containsKey(methodSignature)) {
            if (!this.dummyOverride) throw new RuntimeException("serviceName '" + serviceName + " ' and methodName '" + serviceExporter.getMethodName() + "' aready exist.");
            this.serviceMap.put(methodSignature, new IDLServiceRpcHandler(serviceExporter));
            return;
        } else {
            this.serviceMap.put(methodSignature, new IDLServiceRpcHandler(serviceExporter));
        }
    }

    public void unRegisterDynamicService(String methodName) {
        String methodSignature = ServiceSignatureUtils.makeSignature("__DYANMICE_SERVICE__", methodName);
        this.serviceMap.remove(methodSignature);
    }

    public void unRegisterDynamicService(String serviceName, String methodName) {
        String methodSignature = ServiceSignatureUtils.makeSignature(serviceName, methodName);
        this.serviceMap.remove(methodSignature);
    }
}

