/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport;

import com.baidu.jprotobuf.pbrpc.transport.ChannelPoolObjectFactory;
import com.baidu.jprotobuf.pbrpc.transport.Connection;
import com.baidu.jprotobuf.pbrpc.transport.RpcClient;
import com.baidu.jprotobuf.pbrpc.transport.RpcClientOptions;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class ChannelPool {
    private static final Logger LOGGER = Logger.getLogger(ChannelPool.class.getName());
    private final RpcClientOptions clientConfig;
    private final PooledObjectFactory<Connection> objectFactory;
    private final GenericObjectPool<Connection> pool;

    public ChannelPool(RpcClient rpcClient, String host, int port) {
        this.clientConfig = rpcClient.getRpcClientOptions();
        this.objectFactory = new ChannelPoolObjectFactory(rpcClient, host, port);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setJmxEnabled(this.clientConfig.isJmxEnabled());
        this.pool = new GenericObjectPool(this.objectFactory, config);
        this.pool.setMaxIdle(this.clientConfig.getMaxIdleSize());
        this.pool.setMaxTotal(this.clientConfig.getThreadPoolSize());
        this.pool.setMaxWaitMillis(this.clientConfig.getMaxWait());
        this.pool.setMinIdle(this.clientConfig.getMinIdleSize());
        this.pool.setMinEvictableIdleTimeMillis(this.clientConfig.getMinEvictableIdleTime());
        this.pool.setTestOnBorrow(this.clientConfig.isTestOnBorrow());
        this.pool.setTestOnReturn(this.clientConfig.isTestOnReturn());
        this.pool.setLifo(this.clientConfig.isLifo());
    }

    public Connection getChannel() {
        Connection channel = null;
        try {
            channel = !this.clientConfig.isShortConnection() ? (Connection)this.pool.borrowObject() : (Connection)this.objectFactory.makeObject().getObject();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return channel;
    }

    public void returnChannel(Connection channel) {
        try {
            if (!this.clientConfig.isShortConnection()) {
                this.pool.returnObject((Object)channel);
            } else if (channel.getFuture().channel().isOpen()) {
                channel.getFuture().channel().close();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void stop() {
        try {
            if (this.pool != null) {
                this.pool.clear();
                this.pool.close();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "stop channel failed!", e);
        }
    }
}

