/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport;

import com.baidu.jprotobuf.pbrpc.transport.ChannelPool;
import com.baidu.jprotobuf.pbrpc.transport.RpcClientCallState;
import com.baidu.jprotobuf.pbrpc.transport.RpcClientOptions;
import com.baidu.jprotobuf.pbrpc.transport.RpcClientPipelineinitializer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultMessageSizeEstimator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class RpcClient
extends Bootstrap {
    private static final int DEFAULT_TICKS_PER_WHEEL = 2048;
    private static final int DEFAULT_TICK_DURATION = 100;
    private final Map<Long, RpcClientCallState> requestMap = new ConcurrentHashMap<Long, RpcClientCallState>();
    private AtomicLong correlationId = new AtomicLong(1L);
    private static Timer timer = RpcClient.createTimer();
    private RpcClientOptions rpcClientOptions;
    private ChannelPool channelPool;
    private EventLoopGroup workerGroup;
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger();

    private static Timer createTimer() {
        HashedWheelTimer timer = new HashedWheelTimer(Executors.defaultThreadFactory(), 100L, TimeUnit.MILLISECONDS, 2048);
        return timer;
    }

    public RpcClient() {
        this(NioSocketChannel.class);
    }

    public RpcClient(RpcClientOptions rpcClientOptions) {
        this(NioSocketChannel.class, rpcClientOptions);
    }

    public RpcClient(Class<? extends Channel> clientChannelClass) {
        this(NioSocketChannel.class, new RpcClientOptions());
    }

    public RpcClient(Class<? extends Channel> clientChannelClass, RpcClientOptions rpcClientOptions) {
        this.workerGroup = rpcClientOptions.getIoEventGroupType() == 0 ? new NioEventLoopGroup(rpcClientOptions.getThreadPoolSize()) : new EpollEventLoopGroup(rpcClientOptions.getThreadPoolSize());
        this.group(this.workerGroup);
        this.channel(clientChannelClass);
        this.handler((ChannelHandler)new RpcClientPipelineinitializer(this));
        this.rpcClientOptions = rpcClientOptions;
        this.option(ChannelOption.SO_REUSEADDR, rpcClientOptions.isReuseAddress());
        this.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, rpcClientOptions.getConnectTimeout());
        this.option(ChannelOption.SO_SNDBUF, rpcClientOptions.getSendBufferSize());
        this.option(ChannelOption.SO_RCVBUF, rpcClientOptions.getSendBufferSize());
        this.option(ChannelOption.SO_KEEPALIVE, rpcClientOptions.isKeepAlive());
        this.option(ChannelOption.TCP_NODELAY, rpcClientOptions.getTcpNoDelay());
        this.option(ChannelOption.MESSAGE_SIZE_ESTIMATOR, new DefaultMessageSizeEstimator(rpcClientOptions.getReceiveBufferSize()));
        INSTANCE_COUNT.incrementAndGet();
    }

    public RpcClientCallState removePendingRequest(long seqId) {
        return this.requestMap.remove(seqId);
    }

    public void registerPendingRequest(long seqId, RpcClientCallState state) {
        if (this.requestMap.containsKey(seqId)) {
            throw new IllegalArgumentException("State already registered");
        }
        this.requestMap.put(seqId, state);
    }

    public void invalidBrokenChannel(Channel channel, Throwable e) {
        ArrayList<RpcClientCallState> values = new ArrayList<RpcClientCallState>(this.requestMap.values());
        for (RpcClientCallState rpcClientCallState : values) {
            boolean currentChannel = rpcClientCallState.isCurrentChannel(channel);
            if (!currentChannel) continue;
            rpcClientCallState.handleFailure(e.getMessage());
            Long id = rpcClientCallState.getDataPackage().getRpcMeta().getCorrelationId();
            this.requestMap.remove(id);
        }
    }

    public long getNextCorrelationId() {
        return this.correlationId.getAndIncrement();
    }

    public Timer getTimer() {
        return timer;
    }

    public RpcClientOptions getRpcClientOptions() {
        return this.rpcClientOptions;
    }

    public void setRpcClientOptions(RpcClientOptions rpcClientOptions) {
        this.rpcClientOptions = rpcClientOptions;
    }

    protected ChannelPool getChannelPool() {
        return this.channelPool;
    }

    protected void setChannelPool(ChannelPool channelPool) {
        this.channelPool = channelPool;
    }

    public void shutdown() {
        int count;
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.channelPool != null) {
            this.channelPool.stop();
        }
        if ((count = INSTANCE_COUNT.decrementAndGet()) == 0 && timer != null) {
            timer.stop();
            timer = RpcClient.createTimer();
        }
    }

    public void stop() {
        this.shutdown();
    }
}

