/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport;

import com.baidu.jprotobuf.pbrpc.server.RpcServiceRegistry;
import com.baidu.jprotobuf.pbrpc.transport.ExceptionCatcher;
import com.baidu.jprotobuf.pbrpc.transport.RpcServerOptions;
import com.baidu.jprotobuf.pbrpc.transport.handler.RpcDataPackageCompressHandler;
import com.baidu.jprotobuf.pbrpc.transport.handler.RpcDataPackageDecoder;
import com.baidu.jprotobuf.pbrpc.transport.handler.RpcDataPackageEncoder;
import com.baidu.jprotobuf.pbrpc.transport.handler.RpcDataPackageUnCompressHandler;
import com.baidu.jprotobuf.pbrpc.transport.handler.RpcServerChannelIdleHandler;
import com.baidu.jprotobuf.pbrpc.transport.handler.RpcServiceHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcServerPipelineInitializer
extends ChannelInitializer<Channel> {
    private static final String DECODER = "decoder";
    private static final String UNCOMPRESS = "uncompress";
    private static final String COMPRESS = "compress";
    private static final String RPC_SERVER_HANDLER = "rpc_handler";
    private static Logger LOG = Logger.getLogger(RpcServerPipelineInitializer.class.getName());
    private final RpcServiceRegistry rpcServiceRegistry;
    private static final String RPC_CHANNEL_STATE_AWARE_HANDLER = "RpcChannelStateAwareHandler";
    private static final String RPC_CHANNEL_IDLE_HANDLER = "idel_channal_handler";
    private static final String SERVER_DATA_PACK = "server_data_pack";
    private final RpcServerOptions rpcServerOptions;
    private List<RpcDataPackageDecoder> rpcDataPackageDecoderList = new ArrayList<RpcDataPackageDecoder>();
    private ExecutorService es;
    private ExceptionCatcher exceptionCatcher;

    public void setExceptionCatcher(ExceptionCatcher exceptionCatcher) {
        this.exceptionCatcher = exceptionCatcher;
    }

    public RpcServerPipelineInitializer(RpcServiceRegistry rpcServiceRegistry, RpcServerOptions rpcServerOptions, ExecutorService es, ExceptionCatcher exceptionCatcher) {
        this.rpcServiceRegistry = rpcServiceRegistry;
        this.rpcServerOptions = rpcServerOptions;
        this.es = es;
        this.exceptionCatcher = exceptionCatcher;
    }

    protected void initChannel(Channel ch) throws Exception {
        LOG.log(Level.FINE, "begin process RPC server handler");
        ChannelPipeline channelPipe = ch.pipeline();
        channelPipe.addLast(RPC_CHANNEL_STATE_AWARE_HANDLER, (ChannelHandler)new IdleStateHandler(this.rpcServerOptions.getReaderIdleTime(), this.rpcServerOptions.getWriterIdleTime(), this.rpcServerOptions.getKeepAliveTime()));
        channelPipe.addLast(RPC_CHANNEL_IDLE_HANDLER, (ChannelHandler)new RpcServerChannelIdleHandler());
        int messageLengthFieldStart = 4;
        int messageLengthFieldWidth = 4;
        int adjustSize = 4;
        channelPipe.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.rpcServerOptions.getMaxSize(), messageLengthFieldStart, messageLengthFieldWidth, adjustSize, 0));
        RpcDataPackageDecoder rpcDataPackageDecoder = new RpcDataPackageDecoder(this.rpcServerOptions.getChunkPackageTimeout());
        this.rpcDataPackageDecoderList.add(rpcDataPackageDecoder);
        channelPipe.addLast(DECODER, (ChannelHandler)rpcDataPackageDecoder);
        channelPipe.addLast(UNCOMPRESS, (ChannelHandler)new RpcDataPackageUnCompressHandler());
        RpcServiceHandler rpcServiceHandler = new RpcServiceHandler(this.rpcServiceRegistry, this.exceptionCatcher);
        rpcServiceHandler.setEs(this.es);
        channelPipe.addLast(RPC_SERVER_HANDLER, (ChannelHandler)rpcServiceHandler);
        channelPipe.addFirst(COMPRESS, (ChannelHandler)new RpcDataPackageCompressHandler());
        channelPipe.addFirst(SERVER_DATA_PACK, (ChannelHandler)new RpcDataPackageEncoder());
    }

    public void close() {
        if (this.rpcDataPackageDecoderList.isEmpty()) {
            return;
        }
        ArrayList<RpcDataPackageDecoder> list = new ArrayList<RpcDataPackageDecoder>(this.rpcDataPackageDecoderList);
        for (RpcDataPackageDecoder rpcDataPackageDecoder : list) {
            rpcDataPackageDecoder.close();
        }
    }
}

