/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport.handler;

import com.baidu.jprotobuf.pbrpc.compress.Compress;
import com.baidu.jprotobuf.pbrpc.compress.GZipCompress;
import com.baidu.jprotobuf.pbrpc.compress.SnappyCompress;
import com.baidu.jprotobuf.pbrpc.data.RpcDataPackage;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;

@ChannelHandler.Sharable
public class RpcDataPackageCompressHandler
extends MessageToMessageEncoder<RpcDataPackage> {
    protected void encode(ChannelHandlerContext ctx, RpcDataPackage msg, List<Object> out) throws Exception {
        RpcDataPackage dataPackage = msg;
        Integer compressType = dataPackage.getRpcMeta().getCompressType();
        Compress compress = null;
        if (compressType == 2) {
            compress = new GZipCompress();
        } else if (compressType == 1) {
            compress = new SnappyCompress();
        }
        if (compress != null) {
            byte[] data = dataPackage.getData();
            data = compress.compress(data);
            dataPackage.data(data);
        }
        out.add(dataPackage);
    }
}

