/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport.handler;

import com.baidu.jprotobuf.pbrpc.compress.Compress;
import com.baidu.jprotobuf.pbrpc.compress.GZipCompress;
import com.baidu.jprotobuf.pbrpc.compress.SnappyCompress;
import com.baidu.jprotobuf.pbrpc.data.RpcDataPackage;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;

@ChannelHandler.Sharable
public class RpcDataPackageUnCompressHandler
extends MessageToMessageDecoder<RpcDataPackage> {
    protected void decode(ChannelHandlerContext ctx, RpcDataPackage msg, List<Object> out) throws Exception {
        RpcDataPackage dataPackage = msg;
        try {
            Integer compressType = dataPackage.getRpcMeta().getCompressType();
            Compress compress = null;
            if (compressType == 2) {
                compress = new GZipCompress();
            } else if (compressType == 1) {
                compress = new SnappyCompress();
            }
            if (compress != null) {
                byte[] data = dataPackage.getData();
                data = compress.unCompress(data);
                dataPackage.data(data);
            }
        }
        catch (Exception e) {
            dataPackage.errorCode(3000);
            dataPackage.errorText("Data uncompress failed due to " + e.getMessage());
        }
        out.add(dataPackage);
    }
}

