/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.utils;

import java.lang.reflect.Method;

public class ReflectionUtils {
    public static void doWithMethods(Class<?> targetClass, MethodCallback mc) throws IllegalArgumentException {
        ReflectionUtils.doWithMethods(targetClass, mc, null);
    }

    public static void doWithMethods(Class<?> targetClass, MethodCallback mc, MethodFilter mf) throws IllegalArgumentException {
        do {
            Method[] methods = targetClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (mf != null && !mf.matches(methods[i])) continue;
                try {
                    mc.doWith(methods[i]);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access method '" + methods[i].getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null);
    }

    public static boolean isVoid(Class<?> cls) {
        return cls == Void.class || cls == Void.TYPE;
    }

    public static interface MethodFilter {
        public boolean matches(Method var1);
    }

    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

