/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.data;

import com.baidu.jprotobuf.pbrpc.data.ProtocolConstant;
import com.baidu.jprotobuf.pbrpc.data.Readable;
import com.baidu.jprotobuf.pbrpc.data.Writerable;
import java.nio.ByteBuffer;

public class RpcHeadMeta
implements Writerable,
Readable {
    public static final int SIZE = 12;
    private byte[] magicCode;
    private int messageSize;
    private int metaSize;

    public byte[] getMagicCode() {
        return this.magicCode;
    }

    public String getMagicCodeAsString() {
        if (this.magicCode == null) {
            return null;
        }
        return new String(this.magicCode, ProtocolConstant.CHARSET);
    }

    public void setMagicCode(String magicCode) {
        if (magicCode == null) {
            throw new IllegalArgumentException("invalid magic code. size must be 4.");
        }
        this.setMagicCode(magicCode.getBytes(ProtocolConstant.CHARSET));
    }

    public void setMagicCode(byte[] magicCode) {
        if (magicCode == null || magicCode.length != 4) {
            throw new IllegalArgumentException("invalid magic code. size must be 4.");
        }
        this.magicCode = magicCode;
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public void setMessageSize(int messageSize) {
        this.messageSize = messageSize;
    }

    public int getMetaSize() {
        return this.metaSize;
    }

    public void setMetaSize(int metaSize) {
        this.metaSize = metaSize;
    }

    @Override
    public byte[] write() {
        ByteBuffer allocate = ByteBuffer.allocate(12);
        allocate.put(this.magicCode);
        allocate.putInt(this.messageSize);
        allocate.putInt(this.metaSize);
        byte[] ret = allocate.array();
        allocate.clear();
        return ret;
    }

    @Override
    public void read(byte[] bytes) {
        if (bytes == null || bytes.length != 12) {
            throw new IllegalArgumentException("invalid byte array. size must be 12");
        }
        ByteBuffer allocate = ByteBuffer.wrap(bytes);
        this.magicCode = new byte[4];
        allocate.get(this.magicCode);
        this.messageSize = allocate.getInt();
        this.metaSize = allocate.getInt();
        allocate.clear();
    }

    public RpcHeadMeta copy() {
        RpcHeadMeta rpcHeadMeta = new RpcHeadMeta();
        rpcHeadMeta.setMagicCode(this.getMagicCode());
        rpcHeadMeta.setMessageSize(this.getMessageSize());
        rpcHeadMeta.setMetaSize(this.getMetaSize());
        return rpcHeadMeta;
    }
}

