/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.data;

import com.baidu.bjf.remoting.protobuf.Codec;
import com.baidu.bjf.remoting.protobuf.FieldType;
import com.baidu.bjf.remoting.protobuf.ProtobufProxy;
import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;
import com.baidu.jprotobuf.pbrpc.data.ChunkInfo;
import com.baidu.jprotobuf.pbrpc.data.Readable;
import com.baidu.jprotobuf.pbrpc.data.RpcRequestMeta;
import com.baidu.jprotobuf.pbrpc.data.RpcResponseMeta;
import com.baidu.jprotobuf.pbrpc.data.Writerable;
import java.io.IOException;

public class RpcMeta
implements Readable,
Writerable,
Cloneable {
    public static final int COMPRESS_NO = 0;
    public static final int COMPRESS_SNAPPY = 1;
    public static final int COMPERESS_GZIP = 2;
    private static final Codec<RpcMeta> CODEC = ProtobufProxy.create(RpcMeta.class, (boolean)false);
    @Protobuf(fieldType=FieldType.OBJECT, order=1)
    private RpcRequestMeta request;
    @Protobuf(fieldType=FieldType.OBJECT, order=2)
    private RpcResponseMeta response;
    @Protobuf(order=3)
    private Integer compressType;
    @Protobuf(order=4)
    private Long correlationId;
    @Protobuf(order=5)
    private Integer attachmentSize;
    @Protobuf(order=6)
    private ChunkInfo chunkInfo;
    @Protobuf(fieldType=FieldType.BYTES, order=7)
    private byte[] authenticationData;

    public RpcRequestMeta getRequest() {
        return this.request;
    }

    public void setRequest(RpcRequestMeta request) {
        this.request = request;
    }

    public RpcResponseMeta getResponse() {
        return this.response;
    }

    public void setResponse(RpcResponseMeta response) {
        this.response = response;
    }

    public Integer getCompressType() {
        if (this.compressType == null) {
            this.compressType = 0;
        }
        return this.compressType;
    }

    public void setCompressType(Integer compressType) {
        this.compressType = compressType;
    }

    public Long getCorrelationId() {
        if (this.correlationId == null) {
            this.correlationId = 0L;
        }
        return this.correlationId;
    }

    public void setCorrelationId(Long correlationId) {
        this.correlationId = correlationId;
    }

    public Integer getAttachmentSize() {
        if (this.attachmentSize == null) {
            return 0;
        }
        return this.attachmentSize;
    }

    public void setAttachmentSize(Integer attachmentSize) {
        this.attachmentSize = attachmentSize;
    }

    public byte[] getAuthenticationData() {
        return this.authenticationData;
    }

    public void setAuthenticationData(byte[] authenticationData) {
        this.authenticationData = authenticationData;
    }

    @Override
    public byte[] write() {
        try {
            return CODEC.encode((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void read(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("param 'bytes' is null.");
        }
        try {
            RpcMeta meta = (RpcMeta)CODEC.decode(bytes);
            this.copyReference(meta);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void copyReference(RpcMeta meta) {
        if (meta == null) {
            return;
        }
        this.setRequest(meta.getRequest());
        this.setResponse(meta.getResponse());
        this.setAttachmentSize(meta.getAttachmentSize());
        this.setAuthenticationData(meta.getAuthenticationData());
        this.setCompressType(meta.getCompressType());
        this.setCorrelationId(meta.getCorrelationId());
        this.setChunkInfo(meta.getChunkInfo());
    }

    public RpcMeta copy() {
        RpcMeta rpcMeta = new RpcMeta();
        if (this.chunkInfo != null) {
            rpcMeta.setChunkInfo(this.chunkInfo.copy());
        }
        if (this.request != null) {
            rpcMeta.setRequest(this.request.copy());
        }
        if (this.response != null) {
            rpcMeta.setResponse(this.response.copy());
        }
        rpcMeta.setAttachmentSize(this.attachmentSize);
        rpcMeta.setAuthenticationData(this.authenticationData);
        rpcMeta.setCompressType(this.compressType);
        rpcMeta.setCorrelationId(this.correlationId);
        return rpcMeta;
    }

    public ChunkInfo getChunkInfo() {
        return this.chunkInfo;
    }

    public void setChunkInfo(ChunkInfo chunkInfo) {
        this.chunkInfo = chunkInfo;
    }
}

