/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.data;

import com.baidu.bjf.remoting.protobuf.Codec;
import com.baidu.bjf.remoting.protobuf.FieldType;
import com.baidu.bjf.remoting.protobuf.ProtobufProxy;
import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;
import com.baidu.jprotobuf.pbrpc.data.Readable;
import com.baidu.jprotobuf.pbrpc.data.RpcRequestMetaExtField;
import com.baidu.jprotobuf.pbrpc.data.Writerable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RpcRequestMeta
implements Readable,
Writerable {
    private static final Codec<RpcRequestMeta> CODEC = ProtobufProxy.create(RpcRequestMeta.class, (boolean)false);
    @Protobuf(required=true, order=1)
    private String serviceName;
    @Protobuf(required=true, order=2)
    private String methodName;
    @Protobuf(order=3)
    private Long logId;
    @Protobuf(order=4)
    private Long traceId;
    @Protobuf(order=5)
    private Long spanId;
    @Protobuf(order=6)
    private Long parentSpanId;
    @Protobuf(order=7)
    private List<RpcRequestMetaExtField> extFields;
    @Protobuf(fieldType=FieldType.BYTES, order=110)
    private byte[] extraParam;
    @Protobuf(order=111)
    private String traceKey;

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Long getLogId() {
        return this.logId;
    }

    public void setLogId(Long logId) {
        this.logId = logId;
    }

    @Override
    public void read(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("param 'bytes' is null.");
        }
        try {
            RpcRequestMeta meta = (RpcRequestMeta)CODEC.decode(bytes);
            this.copy(meta);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void copy(RpcRequestMeta meta) {
        if (meta == null) {
            return;
        }
        this.setLogId(meta.getLogId());
        this.setMethodName(meta.getMethodName());
        this.setServiceName(meta.getServiceName());
        this.setExtraParam(meta.getExtraParam());
        this.setTraceId(meta.getTraceId());
        this.setSpanId(meta.getSpanId());
        this.setParentSpanId(meta.getParentSpanId());
        this.setExtFields(meta.getExtFields());
        this.setTraceKey(meta.getTraceKey());
    }

    @Override
    public byte[] write() {
        try {
            return CODEC.encode((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public byte[] getExtraParam() {
        return this.extraParam;
    }

    public void setExtraParam(byte[] extraParam) {
        this.extraParam = extraParam;
    }

    public RpcRequestMeta copy() {
        RpcRequestMeta rpcRequestMeta = new RpcRequestMeta();
        rpcRequestMeta.copy(this);
        return rpcRequestMeta;
    }

    public List<RpcRequestMetaExtField> getExtFields() {
        return this.extFields;
    }

    public Map<String, String> getExtFieldsAsMap() {
        if (this.extFields == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (RpcRequestMetaExtField rpcRequestMetaExtField : this.extFields) {
            ret.put(rpcRequestMetaExtField.getKey(), rpcRequestMetaExtField.getValue());
        }
        return ret;
    }

    public void setExtFields(List<RpcRequestMetaExtField> extFields) {
        this.extFields = extFields;
    }

    public Long getTraceId() {
        return this.traceId;
    }

    public void setTraceId(Long traceId) {
        this.traceId = traceId;
    }

    public Long getSpanId() {
        return this.spanId;
    }

    public void setSpanId(Long spanId) {
        this.spanId = spanId;
    }

    public Long getParentSpanId() {
        return this.parentSpanId;
    }

    public void setParentSpanId(Long parentSpanId) {
        this.parentSpanId = parentSpanId;
    }

    public String getTraceKey() {
        return this.traceKey;
    }

    public void setTraceKey(String traceKey) {
        this.traceKey = traceKey;
    }
}

