/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.data;

import java.util.UUID;

public class Trace {
    private Long traceId;
    private String traceKey;
    private Long spanId;
    private Long parentSpanId;
    private Trace parent;

    public Trace(Long traceId, String traceKey, Long spanId, Long parentSpanId) {
        this.traceId = traceId;
        this.traceKey = traceKey;
        this.spanId = spanId;
        this.parentSpanId = parentSpanId;
    }

    public static Trace newParentTrace() {
        return new Trace(System.currentTimeMillis(), Trace.uuid(), 0L, 0L);
    }

    public void stepInto() {
        Trace newParent = this.copy();
        this.parentSpanId = this.spanId;
        this.spanId = 0L;
        this.parent = newParent;
    }

    public void stepOver() {
        this.spanId = this.spanId + 1L;
    }

    public void stepReturn() {
        if (this.parent == null) {
            return;
        }
        this.spanId = this.parent.getSpanId();
        this.parentSpanId = this.parent.getParentSpanId();
        this.parent = this.parent.parent;
    }

    public Trace copy() {
        Trace trace = new Trace(this.traceId, this.traceKey, this.spanId, this.parentSpanId);
        trace.parent = this.parent;
        return trace;
    }

    private static String uuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public Long getTraceId() {
        return this.traceId;
    }

    public void setTraceId(Long traceId) {
        this.traceId = traceId;
    }

    public Long getSpanId() {
        return this.spanId;
    }

    public void setSpanId(Long spanId) {
        this.spanId = spanId;
    }

    public Long getParentSpanId() {
        return this.parentSpanId;
    }

    public void setParentSpanId(Long parentSpanId) {
        this.parentSpanId = parentSpanId;
    }

    public String getTraceKey() {
        return this.traceKey;
    }

    public void setTraceKey(String traceKey) {
        this.traceKey = traceKey;
    }

    public Trace getParent() {
        return this.parent;
    }

    public String toString() {
        return "Trace [traceId=" + this.traceId + ", traceKey=" + this.traceKey + ", spanId=" + this.spanId + ", parentSpanId=" + this.parentSpanId + "]";
    }
}

