/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.intercept;

import com.baidu.jprotobuf.pbrpc.intercept.InvokerInterceptor;
import com.baidu.jprotobuf.pbrpc.intercept.MethodInvocationInfo;
import java.util.List;

public class ChainedInvokerInterceptor
implements InvokerInterceptor {
    private List<InvokerInterceptor> interceptors;

    public void setInterceptors(List<InvokerInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public void beforeInvoke(MethodInvocationInfo methodInvocationInfo) {
        if (this.interceptors == null) {
            return;
        }
        for (InvokerInterceptor interceptor : this.interceptors) {
            interceptor.beforeInvoke(methodInvocationInfo);
        }
    }

    @Override
    public Object process(MethodInvocationInfo methodInvocationInfo) {
        if (this.interceptors == null) {
            return null;
        }
        Object result = null;
        for (InvokerInterceptor interceptor : this.interceptors) {
            Object ret = interceptor.process(methodInvocationInfo);
            if (ret == null) continue;
            result = ret;
        }
        return result;
    }

    @Override
    public void afterProcess() {
        if (this.interceptors == null) {
            return;
        }
        for (InvokerInterceptor interceptor : this.interceptors) {
            interceptor.afterProcess();
        }
    }
}

