/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.server;

import com.baidu.bjf.remoting.protobuf.ProtobufIDLGenerator;
import com.baidu.jprotobuf.pbrpc.DummyServerAttachmentHandler;
import com.baidu.jprotobuf.pbrpc.DummyServerAuthenticationDataHandler;
import com.baidu.jprotobuf.pbrpc.LogIDHolder;
import com.baidu.jprotobuf.pbrpc.ProtobufRPCService;
import com.baidu.jprotobuf.pbrpc.RpcHandler;
import com.baidu.jprotobuf.pbrpc.ServerAttachmentHandler;
import com.baidu.jprotobuf.pbrpc.ServerAuthenticationDataHandler;
import com.baidu.jprotobuf.pbrpc.intercept.InvokerInterceptor;
import com.baidu.jprotobuf.pbrpc.intercept.MethodInvocationInfo;
import com.baidu.jprotobuf.pbrpc.management.ServerStatus;
import com.baidu.jprotobuf.pbrpc.meta.RpcMetaAware;
import com.baidu.jprotobuf.pbrpc.server.RpcData;
import com.baidu.jprotobuf.pbrpc.utils.ReflectionUtils;
import com.baidu.jprotobuf.pbrpc.utils.ServiceSignatureUtils;
import com.baidu.jprotobuf.pbrpc.utils.StringUtils;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public abstract class AbstractAnnotationRpcHandler
implements RpcHandler,
RpcMetaAware {
    private static final Logger PERFORMANCE_LOGGER = Logger.getLogger("performance-log");
    private String serviceName;
    private String methodName;
    private Method method;
    private Class inputClass;
    private Class outputClass;
    private Object service;
    private String description;
    private ServerAttachmentHandler attachmentHandler;
    protected String inputIDl;
    protected String outputIDL;
    private InvokerInterceptor interceptor;
    private ServerAuthenticationDataHandler authenticationHandler;
    private String serviceSignature;
    private boolean isByteArrayInputParam = false;

    public void setInterceptor(InvokerInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    protected InvokerInterceptor getInterceptor() {
        return this.interceptor;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object getService() {
        return this.service;
    }

    @Override
    public RpcData doHandle(RpcData data) throws Exception {
        Long logId = data.getLogId();
        if (logId != null) {
            LogIDHolder.setCurrentLogid((long)logId);
        }
        try {
            RpcData rpcData = this.doRealHandle(data);
            return rpcData;
        }
        finally {
            LogIDHolder.clearLogId();
        }
    }

    public AbstractAnnotationRpcHandler(Method method, Object service, ProtobufRPCService protobufPRCService) {
        Class authClass;
        Class attachmentHandlerClass;
        Class<?> returnType;
        this.method = method;
        this.service = service;
        this.description = protobufPRCService.description();
        this.serviceName = protobufPRCService.serviceName();
        this.methodName = protobufPRCService.methodName();
        if (StringUtils.isEmpty(this.methodName)) {
            this.methodName = method.getName();
        }
        this.serviceSignature = ServiceSignatureUtils.makeSignature(this.getServiceName(), this.getMethodName());
        Class<?>[] types = method.getParameterTypes();
        if (types.length > 1) {
            throw new IllegalArgumentException("RPC method can not has more than one parameter. illegal method:" + method.getName());
        }
        if (types.length == 1) {
            this.inputClass = types[0];
            if (byte[].class.equals((Object)this.inputClass)) {
                this.isByteArrayInputParam = true;
            }
        }
        if (!ReflectionUtils.isVoid(returnType = method.getReturnType())) {
            this.outputClass = returnType;
        }
        if ((attachmentHandlerClass = protobufPRCService.attachmentHandler()) != DummyServerAttachmentHandler.class) {
            try {
                this.attachmentHandler = (ServerAttachmentHandler)attachmentHandlerClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalAccessError("Can not initialize 'ServerAttachmentHandler' of class '" + attachmentHandlerClass.getName() + "'");
            }
        }
        if ((authClass = protobufPRCService.authenticationDataHandler()) != DummyServerAuthenticationDataHandler.class) {
            try {
                this.authenticationHandler = (ServerAuthenticationDataHandler)authClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalAccessError("Can not initialize 'ServerAuthenticationDataHandler' of class '" + authClass.getName() + "'");
            }
        }
        if (this.inputClass != null) {
            try {
                this.inputIDl = ProtobufIDLGenerator.getIDL((Class)this.inputClass);
            }
            catch (Exception e) {
                this.inputIDl = null;
            }
        }
        if (this.outputClass != null) {
            try {
                this.outputIDL = ProtobufIDLGenerator.getIDL((Class)this.outputClass);
            }
            catch (Exception e) {
                this.outputIDL = null;
            }
        }
    }

    protected RpcData doRealHandle(RpcData data) throws Exception {
        Object input = null;
        Object ret = null;
        input = this.isByteArrayInputParam ? data.getData() : (Object)this.encodeInputParam(data.getData());
        Object[] param = input != null ? new Object[]{input} : new Object[]{};
        if (this.getAuthenticationHandler() != null) {
            this.getAuthenticationHandler().handle(data.getAuthenticationData(), this.getServiceName(), this.getMethodName(), param);
        }
        RpcData retData = new RpcData();
        if (this.getAttachmentHandler() != null) {
            byte[] responseAttachment = this.getAttachmentHandler().handleAttachement(data.getAttachment(), this.getServiceName(), this.getMethodName(), param);
            retData.setAttachment(responseAttachment);
        }
        long time = System.currentTimeMillis();
        try {
            if (this.getInterceptor() != null) {
                MethodInvocationInfo methodInvocationInfo = new MethodInvocationInfo(this.getService(), param, this.getMethod(), data.getExtraParams(), data.getExtFields());
                this.getInterceptor().beforeInvoke(methodInvocationInfo);
                ret = this.getInterceptor().process(methodInvocationInfo);
                if (ret != null || ret == InvokerInterceptor.NULL) {
                    PERFORMANCE_LOGGER.fine("RPC client invoke method(by intercepter) '" + this.getMethod().getName() + "' time took:" + (System.currentTimeMillis() - time) + " ms");
                    byte[] response = this.decodeOutputParam(ret);
                    if (response != null) {
                        retData.setData(response);
                    }
                    RpcData rpcData = retData;
                    return rpcData;
                }
            }
            ret = this.getMethod().invoke(this.getService(), param);
            long took = System.currentTimeMillis() - time;
            PERFORMANCE_LOGGER.fine("RPC server invoke method(local) '" + this.getMethod().getName() + "' time took:" + took + " ms");
            ServerStatus.incr(this.serviceSignature, took);
            if (ret == null) {
                RpcData rpcData = retData;
                return rpcData;
            }
            byte[] response = this.decodeOutputParam(ret);
            if (response != null) {
                retData.setData(response);
            }
            RpcData rpcData = retData;
            return rpcData;
        }
        finally {
            if (this.getInterceptor() != null) {
                this.getInterceptor().afterProcess();
            }
        }
    }

    protected abstract byte[] decodeOutputParam(Object var1) throws Exception;

    protected abstract Object encodeInputParam(byte[] var1) throws Exception;

    @Override
    public String getMethodSignature() {
        String methodSignature = ServiceSignatureUtils.makeSignature(this.serviceName, this.methodName);
        return methodSignature;
    }

    public Class getInputClass() {
        return this.inputClass;
    }

    public Class getOutputClass() {
        return this.outputClass;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    public ServerAttachmentHandler getAttachmentHandler() {
        return this.attachmentHandler;
    }

    public ServerAuthenticationDataHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    @Override
    public String getInputMetaProto() {
        return this.inputIDl;
    }

    @Override
    public String getOutputMetaProto() {
        return this.outputIDL;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

