/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport;

import com.baidu.jprotobuf.pbrpc.transport.Connection;
import com.baidu.jprotobuf.pbrpc.transport.RpcClientCallState;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcChannelFutureListener
implements ChannelFutureListener {
    private static Logger LOG = Logger.getLogger(RpcChannelFutureListener.class.getName());
    private Connection conn;

    public RpcChannelFutureListener(Connection conn) {
        this.conn = conn;
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (!future.isSuccess()) {
            LOG.log(Level.WARNING, "build channel:" + future.channel() + " failed");
            this.conn.setIsConnected(false);
            return;
        }
        RpcClientCallState requestState = null;
        while ((requestState = this.conn.consumeRequest()) != null) {
            LOG.log(Level.FINEST, "[correlationId:" + requestState.getDataPackage().getRpcMeta().getCorrelationId() + "] send over from queue");
            Channel channel = this.conn.getFuture().channel();
            requestState.setChannel(channel);
            LOG.log(Level.FINE, "Do send request with service name '" + requestState.getDataPackage().serviceName() + "' method name '" + requestState.getDataPackage().methodName() + "' bound channel =>" + channel);
            channel.writeAndFlush((Object)requestState.getDataPackage());
        }
    }
}

