/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport;

import com.baidu.jprotobuf.pbrpc.transport.RpcClient;
import com.baidu.jprotobuf.pbrpc.transport.RpcClientCallState;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcTimerTask
implements TimerTask {
    public static Logger LOG = Logger.getLogger(RpcTimerTask.class.getName());
    private long correlationId;
    private RpcClient rpcClient;
    private final long time;
    private final TimeUnit timeUnit;

    public RpcTimerTask(long correlationId, RpcClient client, long timeOut, TimeUnit timeUnit) {
        this.correlationId = correlationId;
        this.rpcClient = client;
        this.time = timeOut;
        this.timeUnit = timeUnit;
    }

    public void run(Timeout timeout) throws Exception {
        RpcClientCallState state = this.rpcClient.removePendingRequest(this.correlationId);
        if (state != null) {
            String msg = "correlationId:" + this.correlationId + " timeout with bound channel =>" + state.getChannel();
            LOG.log(Level.WARNING, msg);
            state.handleTimeout(this.time, this.timeUnit, msg);
        } else {
            LOG.log(Level.FINE, "correlationId:" + this.correlationId + ": is timeout and no PendingClientCallState found for correlationId " + this.correlationId);
        }
    }
}

